/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services.stub;

import com.google.ads.googleads.v6.resources.AccountLink;
import com.google.ads.googleads.v6.services.CreateAccountLinkRequest;
import com.google.ads.googleads.v6.services.CreateAccountLinkResponse;
import com.google.ads.googleads.v6.services.GetAccountLinkRequest;
import com.google.ads.googleads.v6.services.MutateAccountLinkRequest;
import com.google.ads.googleads.v6.services.MutateAccountLinkResponse;
import com.google.ads.googleads.v6.services.stub.AccountLinkServiceStub;
import com.google.ads.googleads.v6.services.stub.AccountLinkServiceStubSettings;
import com.google.ads.googleads.v6.services.stub.GrpcAccountLinkServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcAccountLinkServiceStub
extends AccountLinkServiceStub {
    private static final MethodDescriptor<GetAccountLinkRequest, AccountLink> getAccountLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.AccountLinkService/GetAccountLink").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAccountLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AccountLink.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateAccountLinkRequest, CreateAccountLinkResponse> createAccountLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.AccountLinkService/CreateAccountLink").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateAccountLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CreateAccountLinkResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateAccountLinkRequest, MutateAccountLinkResponse> mutateAccountLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.AccountLinkService/MutateAccountLink").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateAccountLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateAccountLinkResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetAccountLinkRequest, AccountLink> getAccountLinkCallable;
    private final UnaryCallable<CreateAccountLinkRequest, CreateAccountLinkResponse> createAccountLinkCallable;
    private final UnaryCallable<MutateAccountLinkRequest, MutateAccountLinkResponse> mutateAccountLinkCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAccountLinkServiceStub create(AccountLinkServiceStubSettings settings) throws IOException {
        return new GrpcAccountLinkServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAccountLinkServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAccountLinkServiceStub(AccountLinkServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAccountLinkServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAccountLinkServiceStub(AccountLinkServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAccountLinkServiceStub(AccountLinkServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAccountLinkServiceCallableFactory());
    }

    protected GrpcAccountLinkServiceStub(AccountLinkServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getAccountLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAccountLinkMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAccountLinkRequest>(){

            public Map<String, String> extract(GetAccountLinkRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createAccountLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createAccountLinkMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateAccountLinkRequest>(){

            public Map<String, String> extract(CreateAccountLinkRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateAccountLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateAccountLinkMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateAccountLinkRequest>(){

            public Map<String, String> extract(MutateAccountLinkRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getAccountLinkCallable = callableFactory.createUnaryCallable(getAccountLinkTransportSettings, settings.getAccountLinkSettings(), clientContext);
        this.createAccountLinkCallable = callableFactory.createUnaryCallable(createAccountLinkTransportSettings, settings.createAccountLinkSettings(), clientContext);
        this.mutateAccountLinkCallable = callableFactory.createUnaryCallable(mutateAccountLinkTransportSettings, settings.mutateAccountLinkSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetAccountLinkRequest, AccountLink> getAccountLinkCallable() {
        return this.getAccountLinkCallable;
    }

    @Override
    public UnaryCallable<CreateAccountLinkRequest, CreateAccountLinkResponse> createAccountLinkCallable() {
        return this.createAccountLinkCallable;
    }

    @Override
    public UnaryCallable<MutateAccountLinkRequest, MutateAccountLinkResponse> mutateAccountLinkCallable() {
        return this.mutateAccountLinkCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

