/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services.stub;

import com.google.ads.googleads.v6.resources.AdGroupAdLabel;
import com.google.ads.googleads.v6.services.GetAdGroupAdLabelRequest;
import com.google.ads.googleads.v6.services.MutateAdGroupAdLabelsRequest;
import com.google.ads.googleads.v6.services.MutateAdGroupAdLabelsResponse;
import com.google.ads.googleads.v6.services.stub.AdGroupAdLabelServiceStub;
import com.google.ads.googleads.v6.services.stub.AdGroupAdLabelServiceStubSettings;
import com.google.ads.googleads.v6.services.stub.GrpcAdGroupAdLabelServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcAdGroupAdLabelServiceStub
extends AdGroupAdLabelServiceStub {
    private static final MethodDescriptor<GetAdGroupAdLabelRequest, AdGroupAdLabel> getAdGroupAdLabelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.AdGroupAdLabelService/GetAdGroupAdLabel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAdGroupAdLabelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdGroupAdLabel.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateAdGroupAdLabelsRequest, MutateAdGroupAdLabelsResponse> mutateAdGroupAdLabelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.AdGroupAdLabelService/MutateAdGroupAdLabels").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateAdGroupAdLabelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateAdGroupAdLabelsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetAdGroupAdLabelRequest, AdGroupAdLabel> getAdGroupAdLabelCallable;
    private final UnaryCallable<MutateAdGroupAdLabelsRequest, MutateAdGroupAdLabelsResponse> mutateAdGroupAdLabelsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdGroupAdLabelServiceStub create(AdGroupAdLabelServiceStubSettings settings) throws IOException {
        return new GrpcAdGroupAdLabelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdGroupAdLabelServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdGroupAdLabelServiceStub(AdGroupAdLabelServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdGroupAdLabelServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdGroupAdLabelServiceStub(AdGroupAdLabelServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdGroupAdLabelServiceStub(AdGroupAdLabelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdGroupAdLabelServiceCallableFactory());
    }

    protected GrpcAdGroupAdLabelServiceStub(AdGroupAdLabelServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getAdGroupAdLabelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAdGroupAdLabelMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAdGroupAdLabelRequest>(){

            public Map<String, String> extract(GetAdGroupAdLabelRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateAdGroupAdLabelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateAdGroupAdLabelsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateAdGroupAdLabelsRequest>(){

            public Map<String, String> extract(MutateAdGroupAdLabelsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getAdGroupAdLabelCallable = callableFactory.createUnaryCallable(getAdGroupAdLabelTransportSettings, settings.getAdGroupAdLabelSettings(), clientContext);
        this.mutateAdGroupAdLabelsCallable = callableFactory.createUnaryCallable(mutateAdGroupAdLabelsTransportSettings, settings.mutateAdGroupAdLabelsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetAdGroupAdLabelRequest, AdGroupAdLabel> getAdGroupAdLabelCallable() {
        return this.getAdGroupAdLabelCallable;
    }

    @Override
    public UnaryCallable<MutateAdGroupAdLabelsRequest, MutateAdGroupAdLabelsResponse> mutateAdGroupAdLabelsCallable() {
        return this.mutateAdGroupAdLabelsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

