/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services.stub;

import com.google.ads.googleads.v6.resources.CampaignLabel;
import com.google.ads.googleads.v6.services.GetCampaignLabelRequest;
import com.google.ads.googleads.v6.services.MutateCampaignLabelsRequest;
import com.google.ads.googleads.v6.services.MutateCampaignLabelsResponse;
import com.google.ads.googleads.v6.services.stub.CampaignLabelServiceStub;
import com.google.ads.googleads.v6.services.stub.CampaignLabelServiceStubSettings;
import com.google.ads.googleads.v6.services.stub.GrpcCampaignLabelServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcCampaignLabelServiceStub
extends CampaignLabelServiceStub {
    private static final MethodDescriptor<GetCampaignLabelRequest, CampaignLabel> getCampaignLabelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.CampaignLabelService/GetCampaignLabel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCampaignLabelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CampaignLabel.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateCampaignLabelsRequest, MutateCampaignLabelsResponse> mutateCampaignLabelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.CampaignLabelService/MutateCampaignLabels").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateCampaignLabelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateCampaignLabelsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetCampaignLabelRequest, CampaignLabel> getCampaignLabelCallable;
    private final UnaryCallable<MutateCampaignLabelsRequest, MutateCampaignLabelsResponse> mutateCampaignLabelsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCampaignLabelServiceStub create(CampaignLabelServiceStubSettings settings) throws IOException {
        return new GrpcCampaignLabelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCampaignLabelServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCampaignLabelServiceStub(CampaignLabelServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCampaignLabelServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCampaignLabelServiceStub(CampaignLabelServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCampaignLabelServiceStub(CampaignLabelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCampaignLabelServiceCallableFactory());
    }

    protected GrpcCampaignLabelServiceStub(CampaignLabelServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getCampaignLabelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCampaignLabelMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetCampaignLabelRequest>(){

            public Map<String, String> extract(GetCampaignLabelRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateCampaignLabelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateCampaignLabelsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateCampaignLabelsRequest>(){

            public Map<String, String> extract(MutateCampaignLabelsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getCampaignLabelCallable = callableFactory.createUnaryCallable(getCampaignLabelTransportSettings, settings.getCampaignLabelSettings(), clientContext);
        this.mutateCampaignLabelsCallable = callableFactory.createUnaryCallable(mutateCampaignLabelsTransportSettings, settings.mutateCampaignLabelsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetCampaignLabelRequest, CampaignLabel> getCampaignLabelCallable() {
        return this.getCampaignLabelCallable;
    }

    @Override
    public UnaryCallable<MutateCampaignLabelsRequest, MutateCampaignLabelsResponse> mutateCampaignLabelsCallable() {
        return this.mutateCampaignLabelsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

