/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services.stub;

import com.google.ads.googleads.v6.resources.UserInterest;
import com.google.ads.googleads.v6.services.GetUserInterestRequest;
import com.google.ads.googleads.v6.services.stub.GrpcUserInterestServiceCallableFactory;
import com.google.ads.googleads.v6.services.stub.UserInterestServiceStub;
import com.google.ads.googleads.v6.services.stub.UserInterestServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcUserInterestServiceStub
extends UserInterestServiceStub {
    private static final MethodDescriptor<GetUserInterestRequest, UserInterest> getUserInterestMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.UserInterestService/GetUserInterest").setRequestMarshaller(ProtoUtils.marshaller((Message)GetUserInterestRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)UserInterest.getDefaultInstance())).build();
    private final UnaryCallable<GetUserInterestRequest, UserInterest> getUserInterestCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcUserInterestServiceStub create(UserInterestServiceStubSettings settings) throws IOException {
        return new GrpcUserInterestServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcUserInterestServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcUserInterestServiceStub(UserInterestServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcUserInterestServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcUserInterestServiceStub(UserInterestServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcUserInterestServiceStub(UserInterestServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcUserInterestServiceCallableFactory());
    }

    protected GrpcUserInterestServiceStub(UserInterestServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getUserInterestTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getUserInterestMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetUserInterestRequest>(){

            public Map<String, String> extract(GetUserInterestRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getUserInterestCallable = callableFactory.createUnaryCallable(getUserInterestTransportSettings, settings.getUserInterestSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetUserInterestRequest, UserInterest> getUserInterestCallable() {
        return this.getUserInterestCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

