/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccountLinkName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ACCOUNT_LINK_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/accountLinks/{account_link_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String accountLinkId;

    @Deprecated
    protected AccountLinkName() {
        this.customerId = null;
        this.accountLinkId = null;
    }

    private AccountLinkName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.accountLinkId = (String)Preconditions.checkNotNull((Object)builder.getAccountLinkId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAccountLinkId() {
        return this.accountLinkId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccountLinkName of(String customerId, String accountLinkId) {
        return AccountLinkName.newBuilder().setCustomerId(customerId).setAccountLinkId(accountLinkId).build();
    }

    public static String format(String customerId, String accountLinkId) {
        return AccountLinkName.newBuilder().setCustomerId(customerId).setAccountLinkId(accountLinkId).build().toString();
    }

    public static AccountLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ACCOUNT_LINK_ID.validatedMatch(formattedString, "AccountLinkName.parse: formattedString not in valid format");
        return AccountLinkName.of((String)matchMap.get("customer_id"), (String)matchMap.get("account_link_id"));
    }

    public static List<AccountLinkName> parseList(List<String> formattedStrings) {
        ArrayList<AccountLinkName> list = new ArrayList<AccountLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ACCOUNT_LINK_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountLinkName accountLinkName = this;
            synchronized (accountLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.accountLinkId != null) {
                        fieldMapBuilder.put((Object)"account_link_id", (Object)this.accountLinkId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ACCOUNT_LINK_ID.instantiate(new String[]{"customer_id", this.customerId, "account_link_id", this.accountLinkId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AccountLinkName that = (AccountLinkName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.accountLinkId, that.accountLinkId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.accountLinkId);
    }

    public static class Builder {
        private String customerId;
        private String accountLinkId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAccountLinkId() {
            return this.accountLinkId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAccountLinkId(String accountLinkId) {
            this.accountLinkId = accountLinkId;
            return this;
        }

        private Builder(AccountLinkName accountLinkName) {
            this.customerId = accountLinkName.customerId;
            this.accountLinkId = accountLinkName.accountLinkId;
        }

        public AccountLinkName build() {
            return new AccountLinkName(this);
        }
    }
}

