/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignCriterionSimulationName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_CRITERION_ID_TYPE_MODIFICATION_METHOD_START_DATE_END_DATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignCriterionSimulations/{campaign_id}~{criterion_id}~{type}~{modification_method}~{start_date}~{end_date}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String criterionId;
    private final String type;
    private final String modificationMethod;
    private final String startDate;
    private final String endDate;

    @Deprecated
    protected CampaignCriterionSimulationName() {
        this.customerId = null;
        this.campaignId = null;
        this.criterionId = null;
        this.type = null;
        this.modificationMethod = null;
        this.startDate = null;
        this.endDate = null;
    }

    private CampaignCriterionSimulationName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
        this.type = (String)Preconditions.checkNotNull((Object)builder.getType());
        this.modificationMethod = (String)Preconditions.checkNotNull((Object)builder.getModificationMethod());
        this.startDate = (String)Preconditions.checkNotNull((Object)builder.getStartDate());
        this.endDate = (String)Preconditions.checkNotNull((Object)builder.getEndDate());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public String getType() {
        return this.type;
    }

    public String getModificationMethod() {
        return this.modificationMethod;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignCriterionSimulationName of(String customerId, String campaignId, String criterionId, String type, String modificationMethod, String startDate, String endDate) {
        return CampaignCriterionSimulationName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setCriterionId(criterionId).setType(type).setModificationMethod(modificationMethod).setStartDate(startDate).setEndDate(endDate).build();
    }

    public static String format(String customerId, String campaignId, String criterionId, String type, String modificationMethod, String startDate, String endDate) {
        return CampaignCriterionSimulationName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setCriterionId(criterionId).setType(type).setModificationMethod(modificationMethod).setStartDate(startDate).setEndDate(endDate).build().toString();
    }

    public static CampaignCriterionSimulationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_CRITERION_ID_TYPE_MODIFICATION_METHOD_START_DATE_END_DATE.validatedMatch(formattedString, "CampaignCriterionSimulationName.parse: formattedString not in valid format");
        return CampaignCriterionSimulationName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("criterion_id"), (String)matchMap.get("type"), (String)matchMap.get("modification_method"), (String)matchMap.get("start_date"), (String)matchMap.get("end_date"));
    }

    public static List<CampaignCriterionSimulationName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignCriterionSimulationName> list = new ArrayList<CampaignCriterionSimulationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignCriterionSimulationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignCriterionSimulationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignCriterionSimulationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_CRITERION_ID_TYPE_MODIFICATION_METHOD_START_DATE_END_DATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignCriterionSimulationName campaignCriterionSimulationName = this;
            synchronized (campaignCriterionSimulationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    if (this.type != null) {
                        fieldMapBuilder.put((Object)"type", (Object)this.type);
                    }
                    if (this.modificationMethod != null) {
                        fieldMapBuilder.put((Object)"modification_method", (Object)this.modificationMethod);
                    }
                    if (this.startDate != null) {
                        fieldMapBuilder.put((Object)"start_date", (Object)this.startDate);
                    }
                    if (this.endDate != null) {
                        fieldMapBuilder.put((Object)"end_date", (Object)this.endDate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_CRITERION_ID_TYPE_MODIFICATION_METHOD_START_DATE_END_DATE.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "criterion_id", this.criterionId, "type", this.type, "modification_method", this.modificationMethod, "start_date", this.startDate, "end_date", this.endDate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CampaignCriterionSimulationName that = (CampaignCriterionSimulationName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.criterionId, that.criterionId) && Objects.equals(this.type, that.type) && Objects.equals(this.modificationMethod, that.modificationMethod) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.criterionId);
        h *= 1000003;
        h ^= Objects.hashCode(this.type);
        h *= 1000003;
        h ^= Objects.hashCode(this.modificationMethod);
        h *= 1000003;
        h ^= Objects.hashCode(this.startDate);
        h *= 1000003;
        return h ^= Objects.hashCode(this.endDate);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String criterionId;
        private String type;
        private String modificationMethod;
        private String startDate;
        private String endDate;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public String getType() {
            return this.type;
        }

        public String getModificationMethod() {
            return this.modificationMethod;
        }

        public String getStartDate() {
            return this.startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setModificationMethod(String modificationMethod) {
            this.modificationMethod = modificationMethod;
            return this;
        }

        public Builder setStartDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder setEndDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        private Builder(CampaignCriterionSimulationName campaignCriterionSimulationName) {
            this.customerId = campaignCriterionSimulationName.customerId;
            this.campaignId = campaignCriterionSimulationName.campaignId;
            this.criterionId = campaignCriterionSimulationName.criterionId;
            this.type = campaignCriterionSimulationName.type;
            this.modificationMethod = campaignCriterionSimulationName.modificationMethod;
            this.startDate = campaignCriterionSimulationName.startDate;
            this.endDate = campaignCriterionSimulationName.endDate;
        }

        public CampaignCriterionSimulationName build() {
            return new CampaignCriterionSimulationName(this);
        }
    }
}

