/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.ads.googleads.v7.common.MatchingFunction;
import com.google.ads.googleads.v7.common.MatchingFunctionOrBuilder;
import com.google.ads.googleads.v7.enums.FeedLinkStatusEnum;
import com.google.ads.googleads.v7.enums.PlaceholderTypeEnum;
import com.google.ads.googleads.v7.resources.CustomerFeedOrBuilder;
import com.google.ads.googleads.v7.resources.CustomerFeedProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CustomerFeed
extends GeneratedMessageV3
implements CustomerFeedOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_;
    public static final int FEED_FIELD_NUMBER = 6;
    private volatile Object feed_;
    public static final int PLACEHOLDER_TYPES_FIELD_NUMBER = 3;
    private List<Integer> placeholderTypes_;
    private static final Internal.ListAdapter.Converter<Integer, PlaceholderTypeEnum.PlaceholderType> placeholderTypes_converter_ = new Internal.ListAdapter.Converter<Integer, PlaceholderTypeEnum.PlaceholderType>(){

        public PlaceholderTypeEnum.PlaceholderType convert(Integer from) {
            PlaceholderTypeEnum.PlaceholderType result = PlaceholderTypeEnum.PlaceholderType.valueOf(from);
            return result == null ? PlaceholderTypeEnum.PlaceholderType.UNRECOGNIZED : result;
        }
    };
    private int placeholderTypesMemoizedSerializedSize;
    public static final int MATCHING_FUNCTION_FIELD_NUMBER = 4;
    private MatchingFunction matchingFunction_;
    public static final int STATUS_FIELD_NUMBER = 5;
    private int status_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CustomerFeed DEFAULT_INSTANCE = new CustomerFeed();
    private static final Parser<CustomerFeed> PARSER = new AbstractParser<CustomerFeed>(){

        public CustomerFeed parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new CustomerFeed(input, extensionRegistry);
        }
    };

    private CustomerFeed(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CustomerFeed() {
        this.resourceName_ = "";
        this.feed_ = "";
        this.placeholderTypes_ = Collections.emptyList();
        this.status_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new CustomerFeed();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private CustomerFeed(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block15: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block15;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.resourceName_ = s;
                        continue block15;
                    }
                    case 24: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.placeholderTypes_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 2;
                        }
                        this.placeholderTypes_.add(rawValue);
                        continue block15;
                    }
                    case 26: {
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            int rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 2) == 0) {
                                this.placeholderTypes_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 2;
                            }
                            this.placeholderTypes_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block15;
                    }
                    case 34: {
                        MatchingFunction.Builder subBuilder = null;
                        if (this.matchingFunction_ != null) {
                            subBuilder = this.matchingFunction_.toBuilder();
                        }
                        this.matchingFunction_ = (MatchingFunction)input.readMessage(MatchingFunction.parser(), extensionRegistry);
                        if (subBuilder == null) continue block15;
                        subBuilder.mergeFrom(this.matchingFunction_);
                        this.matchingFunction_ = subBuilder.buildPartial();
                        continue block15;
                    }
                    case 40: {
                        int rawValue;
                        this.status_ = rawValue = input.readEnum();
                        continue block15;
                    }
                    case 50: {
                        String s = input.readStringRequireUtf8();
                        this.bitField0_ |= 1;
                        this.feed_ = s;
                        continue block15;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if ((mutable_bitField0_ & 2) != 0) {
                this.placeholderTypes_ = Collections.unmodifiableList(this.placeholderTypes_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CustomerFeedProto.internal_static_google_ads_googleads_v7_resources_CustomerFeed_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CustomerFeedProto.internal_static_google_ads_googleads_v7_resources_CustomerFeed_fieldAccessorTable.ensureFieldAccessorsInitialized(CustomerFeed.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasFeed() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getFeed() {
        Object ref = this.feed_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.feed_ = s;
        return s;
    }

    @Override
    public ByteString getFeedBytes() {
        Object ref = this.feed_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.feed_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<PlaceholderTypeEnum.PlaceholderType> getPlaceholderTypesList() {
        return new Internal.ListAdapter(this.placeholderTypes_, placeholderTypes_converter_);
    }

    @Override
    public int getPlaceholderTypesCount() {
        return this.placeholderTypes_.size();
    }

    @Override
    public PlaceholderTypeEnum.PlaceholderType getPlaceholderTypes(int index) {
        return (PlaceholderTypeEnum.PlaceholderType)((Object)placeholderTypes_converter_.convert((Object)this.placeholderTypes_.get(index)));
    }

    @Override
    public List<Integer> getPlaceholderTypesValueList() {
        return this.placeholderTypes_;
    }

    @Override
    public int getPlaceholderTypesValue(int index) {
        return this.placeholderTypes_.get(index);
    }

    @Override
    public boolean hasMatchingFunction() {
        return this.matchingFunction_ != null;
    }

    @Override
    public MatchingFunction getMatchingFunction() {
        return this.matchingFunction_ == null ? MatchingFunction.getDefaultInstance() : this.matchingFunction_;
    }

    @Override
    public MatchingFunctionOrBuilder getMatchingFunctionOrBuilder() {
        return this.getMatchingFunction();
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public FeedLinkStatusEnum.FeedLinkStatus getStatus() {
        FeedLinkStatusEnum.FeedLinkStatus result = FeedLinkStatusEnum.FeedLinkStatus.valueOf(this.status_);
        return result == null ? FeedLinkStatusEnum.FeedLinkStatus.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!this.getResourceNameBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.getPlaceholderTypesList().size() > 0) {
            output.writeUInt32NoTag(26);
            output.writeUInt32NoTag(this.placeholderTypesMemoizedSerializedSize);
        }
        for (int i = 0; i < this.placeholderTypes_.size(); ++i) {
            output.writeEnumNoTag(this.placeholderTypes_.get(i).intValue());
        }
        if (this.matchingFunction_ != null) {
            output.writeMessage(4, (MessageLite)this.getMatchingFunction());
        }
        if (this.status_ != FeedLinkStatusEnum.FeedLinkStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.status_);
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.feed_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.getResourceNameBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.placeholderTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.placeholderTypes_.get(i));
        }
        size += dataSize;
        if (!this.getPlaceholderTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.placeholderTypesMemoizedSerializedSize = dataSize;
        if (this.matchingFunction_ != null) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getMatchingFunction());
        }
        if (this.status_ != FeedLinkStatusEnum.FeedLinkStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.status_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.feed_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CustomerFeed)) {
            return super.equals(obj);
        }
        CustomerFeed other = (CustomerFeed)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.hasFeed() != other.hasFeed()) {
            return false;
        }
        if (this.hasFeed() && !this.getFeed().equals(other.getFeed())) {
            return false;
        }
        if (!this.placeholderTypes_.equals(other.placeholderTypes_)) {
            return false;
        }
        if (this.hasMatchingFunction() != other.hasMatchingFunction()) {
            return false;
        }
        if (this.hasMatchingFunction() && !this.getMatchingFunction().equals(other.getMatchingFunction())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + CustomerFeed.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        if (this.hasFeed()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getFeed().hashCode();
        }
        if (this.getPlaceholderTypesCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.placeholderTypes_.hashCode();
        }
        if (this.hasMatchingFunction()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getMatchingFunction().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.status_;
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static CustomerFeed parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (CustomerFeed)PARSER.parseFrom(data);
    }

    public static CustomerFeed parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CustomerFeed)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CustomerFeed parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (CustomerFeed)PARSER.parseFrom(data);
    }

    public static CustomerFeed parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CustomerFeed)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CustomerFeed parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (CustomerFeed)PARSER.parseFrom(data);
    }

    public static CustomerFeed parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CustomerFeed)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CustomerFeed parseFrom(InputStream input) throws IOException {
        return (CustomerFeed)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static CustomerFeed parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CustomerFeed)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CustomerFeed parseDelimitedFrom(InputStream input) throws IOException {
        return (CustomerFeed)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static CustomerFeed parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CustomerFeed)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CustomerFeed parseFrom(CodedInputStream input) throws IOException {
        return (CustomerFeed)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static CustomerFeed parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CustomerFeed)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return CustomerFeed.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CustomerFeed prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static CustomerFeed getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CustomerFeed> parser() {
        return PARSER;
    }

    public Parser<CustomerFeed> getParserForType() {
        return PARSER;
    }

    public CustomerFeed getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CustomerFeedOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private Object feed_ = "";
        private List<Integer> placeholderTypes_ = Collections.emptyList();
        private MatchingFunction matchingFunction_;
        private SingleFieldBuilderV3<MatchingFunction, MatchingFunction.Builder, MatchingFunctionOrBuilder> matchingFunctionBuilder_;
        private int status_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return CustomerFeedProto.internal_static_google_ads_googleads_v7_resources_CustomerFeed_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CustomerFeedProto.internal_static_google_ads_googleads_v7_resources_CustomerFeed_fieldAccessorTable.ensureFieldAccessorsInitialized(CustomerFeed.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.resourceName_ = "";
            this.feed_ = "";
            this.bitField0_ &= 0xFFFFFFFE;
            this.placeholderTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.matchingFunctionBuilder_ == null) {
                this.matchingFunction_ = null;
            } else {
                this.matchingFunction_ = null;
                this.matchingFunctionBuilder_ = null;
            }
            this.status_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CustomerFeedProto.internal_static_google_ads_googleads_v7_resources_CustomerFeed_descriptor;
        }

        public CustomerFeed getDefaultInstanceForType() {
            return CustomerFeed.getDefaultInstance();
        }

        public CustomerFeed build() {
            CustomerFeed result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public CustomerFeed buildPartial() {
            CustomerFeed result = new CustomerFeed(this);
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            result.resourceName_ = this.resourceName_;
            if ((from_bitField0_ & 1) != 0) {
                to_bitField0_ |= 1;
            }
            result.feed_ = this.feed_;
            if ((this.bitField0_ & 2) != 0) {
                this.placeholderTypes_ = Collections.unmodifiableList(this.placeholderTypes_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.placeholderTypes_ = this.placeholderTypes_;
            if (this.matchingFunctionBuilder_ == null) {
                result.matchingFunction_ = this.matchingFunction_;
            } else {
                result.matchingFunction_ = (MatchingFunction)this.matchingFunctionBuilder_.build();
            }
            result.status_ = this.status_;
            result.bitField0_ = to_bitField0_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof CustomerFeed) {
                return this.mergeFrom((CustomerFeed)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(CustomerFeed other) {
            if (other == CustomerFeed.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.onChanged();
            }
            if (other.hasFeed()) {
                this.bitField0_ |= 1;
                this.feed_ = other.feed_;
                this.onChanged();
            }
            if (!other.placeholderTypes_.isEmpty()) {
                if (this.placeholderTypes_.isEmpty()) {
                    this.placeholderTypes_ = other.placeholderTypes_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensurePlaceholderTypesIsMutable();
                    this.placeholderTypes_.addAll(other.placeholderTypes_);
                }
                this.onChanged();
            }
            if (other.hasMatchingFunction()) {
                this.mergeMatchingFunction(other.getMatchingFunction());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            CustomerFeed parsedMessage = null;
            try {
                parsedMessage = (CustomerFeed)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (CustomerFeed)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = CustomerFeed.getDefaultInstance().getResourceName();
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CustomerFeed.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasFeed() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getFeed() {
            Object ref = this.feed_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.feed_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFeedBytes() {
            Object ref = this.feed_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.feed_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFeed(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.feed_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearFeed() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.feed_ = CustomerFeed.getDefaultInstance().getFeed();
            this.onChanged();
            return this;
        }

        public Builder setFeedBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CustomerFeed.checkByteStringIsUtf8((ByteString)value);
            this.bitField0_ |= 1;
            this.feed_ = value;
            this.onChanged();
            return this;
        }

        private void ensurePlaceholderTypesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.placeholderTypes_ = new ArrayList<Integer>(this.placeholderTypes_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<PlaceholderTypeEnum.PlaceholderType> getPlaceholderTypesList() {
            return new Internal.ListAdapter(this.placeholderTypes_, placeholderTypes_converter_);
        }

        @Override
        public int getPlaceholderTypesCount() {
            return this.placeholderTypes_.size();
        }

        @Override
        public PlaceholderTypeEnum.PlaceholderType getPlaceholderTypes(int index) {
            return (PlaceholderTypeEnum.PlaceholderType)((Object)placeholderTypes_converter_.convert((Object)this.placeholderTypes_.get(index)));
        }

        public Builder setPlaceholderTypes(int index, PlaceholderTypeEnum.PlaceholderType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePlaceholderTypesIsMutable();
            this.placeholderTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addPlaceholderTypes(PlaceholderTypeEnum.PlaceholderType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePlaceholderTypesIsMutable();
            this.placeholderTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllPlaceholderTypes(Iterable<? extends PlaceholderTypeEnum.PlaceholderType> values) {
            this.ensurePlaceholderTypesIsMutable();
            for (PlaceholderTypeEnum.PlaceholderType placeholderType : values) {
                this.placeholderTypes_.add(placeholderType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearPlaceholderTypes() {
            this.placeholderTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getPlaceholderTypesValueList() {
            return Collections.unmodifiableList(this.placeholderTypes_);
        }

        @Override
        public int getPlaceholderTypesValue(int index) {
            return this.placeholderTypes_.get(index);
        }

        public Builder setPlaceholderTypesValue(int index, int value) {
            this.ensurePlaceholderTypesIsMutable();
            this.placeholderTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addPlaceholderTypesValue(int value) {
            this.ensurePlaceholderTypesIsMutable();
            this.placeholderTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllPlaceholderTypesValue(Iterable<Integer> values) {
            this.ensurePlaceholderTypesIsMutable();
            for (int value : values) {
                this.placeholderTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMatchingFunction() {
            return this.matchingFunctionBuilder_ != null || this.matchingFunction_ != null;
        }

        @Override
        public MatchingFunction getMatchingFunction() {
            if (this.matchingFunctionBuilder_ == null) {
                return this.matchingFunction_ == null ? MatchingFunction.getDefaultInstance() : this.matchingFunction_;
            }
            return (MatchingFunction)this.matchingFunctionBuilder_.getMessage();
        }

        public Builder setMatchingFunction(MatchingFunction value) {
            if (this.matchingFunctionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.matchingFunction_ = value;
                this.onChanged();
            } else {
                this.matchingFunctionBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setMatchingFunction(MatchingFunction.Builder builderForValue) {
            if (this.matchingFunctionBuilder_ == null) {
                this.matchingFunction_ = builderForValue.build();
                this.onChanged();
            } else {
                this.matchingFunctionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeMatchingFunction(MatchingFunction value) {
            if (this.matchingFunctionBuilder_ == null) {
                this.matchingFunction_ = this.matchingFunction_ != null ? MatchingFunction.newBuilder(this.matchingFunction_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.matchingFunctionBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearMatchingFunction() {
            if (this.matchingFunctionBuilder_ == null) {
                this.matchingFunction_ = null;
                this.onChanged();
            } else {
                this.matchingFunction_ = null;
                this.matchingFunctionBuilder_ = null;
            }
            return this;
        }

        public MatchingFunction.Builder getMatchingFunctionBuilder() {
            this.onChanged();
            return (MatchingFunction.Builder)this.getMatchingFunctionFieldBuilder().getBuilder();
        }

        @Override
        public MatchingFunctionOrBuilder getMatchingFunctionOrBuilder() {
            if (this.matchingFunctionBuilder_ != null) {
                return (MatchingFunctionOrBuilder)this.matchingFunctionBuilder_.getMessageOrBuilder();
            }
            return this.matchingFunction_ == null ? MatchingFunction.getDefaultInstance() : this.matchingFunction_;
        }

        private SingleFieldBuilderV3<MatchingFunction, MatchingFunction.Builder, MatchingFunctionOrBuilder> getMatchingFunctionFieldBuilder() {
            if (this.matchingFunctionBuilder_ == null) {
                this.matchingFunctionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMatchingFunction(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.matchingFunction_ = null;
            }
            return this.matchingFunctionBuilder_;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public FeedLinkStatusEnum.FeedLinkStatus getStatus() {
            FeedLinkStatusEnum.FeedLinkStatus result = FeedLinkStatusEnum.FeedLinkStatus.valueOf(this.status_);
            return result == null ? FeedLinkStatusEnum.FeedLinkStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(FeedLinkStatusEnum.FeedLinkStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

