/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerUserAccessInvitationName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_INVITATION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerUserAccessInvitations/{invitation_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String invitationId;

    @Deprecated
    protected CustomerUserAccessInvitationName() {
        this.customerId = null;
        this.invitationId = null;
    }

    private CustomerUserAccessInvitationName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.invitationId = (String)Preconditions.checkNotNull((Object)builder.getInvitationId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getInvitationId() {
        return this.invitationId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerUserAccessInvitationName of(String customerId, String invitationId) {
        return CustomerUserAccessInvitationName.newBuilder().setCustomerId(customerId).setInvitationId(invitationId).build();
    }

    public static String format(String customerId, String invitationId) {
        return CustomerUserAccessInvitationName.newBuilder().setCustomerId(customerId).setInvitationId(invitationId).build().toString();
    }

    public static CustomerUserAccessInvitationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_INVITATION_ID.validatedMatch(formattedString, "CustomerUserAccessInvitationName.parse: formattedString not in valid format");
        return CustomerUserAccessInvitationName.of((String)matchMap.get("customer_id"), (String)matchMap.get("invitation_id"));
    }

    public static List<CustomerUserAccessInvitationName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerUserAccessInvitationName> list = new ArrayList<CustomerUserAccessInvitationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerUserAccessInvitationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerUserAccessInvitationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerUserAccessInvitationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_INVITATION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerUserAccessInvitationName customerUserAccessInvitationName = this;
            synchronized (customerUserAccessInvitationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.invitationId != null) {
                        fieldMapBuilder.put((Object)"invitation_id", (Object)this.invitationId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_INVITATION_ID.instantiate(new String[]{"customer_id", this.customerId, "invitation_id", this.invitationId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomerUserAccessInvitationName that = (CustomerUserAccessInvitationName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.invitationId, that.invitationId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.invitationId);
    }

    public static class Builder {
        private String customerId;
        private String invitationId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getInvitationId() {
            return this.invitationId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setInvitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        private Builder(CustomerUserAccessInvitationName customerUserAccessInvitationName) {
            this.customerId = customerUserAccessInvitationName.customerId;
            this.invitationId = customerUserAccessInvitationName.invitationId;
        }

        public CustomerUserAccessInvitationName build() {
            return new CustomerUserAccessInvitationName(this);
        }
    }
}

