/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeywordPlanAdGroupName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_KEYWORD_PLAN_AD_GROUP_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/keywordPlanAdGroups/{keyword_plan_ad_group_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String keywordPlanAdGroupId;

    @Deprecated
    protected KeywordPlanAdGroupName() {
        this.customerId = null;
        this.keywordPlanAdGroupId = null;
    }

    private KeywordPlanAdGroupName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.keywordPlanAdGroupId = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlanAdGroupId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getKeywordPlanAdGroupId() {
        return this.keywordPlanAdGroupId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeywordPlanAdGroupName of(String customerId, String keywordPlanAdGroupId) {
        return KeywordPlanAdGroupName.newBuilder().setCustomerId(customerId).setKeywordPlanAdGroupId(keywordPlanAdGroupId).build();
    }

    public static String format(String customerId, String keywordPlanAdGroupId) {
        return KeywordPlanAdGroupName.newBuilder().setCustomerId(customerId).setKeywordPlanAdGroupId(keywordPlanAdGroupId).build().toString();
    }

    public static KeywordPlanAdGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_KEYWORD_PLAN_AD_GROUP_ID.validatedMatch(formattedString, "KeywordPlanAdGroupName.parse: formattedString not in valid format");
        return KeywordPlanAdGroupName.of((String)matchMap.get("customer_id"), (String)matchMap.get("keyword_plan_ad_group_id"));
    }

    public static List<KeywordPlanAdGroupName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanAdGroupName> list = new ArrayList<KeywordPlanAdGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanAdGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanAdGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanAdGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_KEYWORD_PLAN_AD_GROUP_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanAdGroupName keywordPlanAdGroupName = this;
            synchronized (keywordPlanAdGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.keywordPlanAdGroupId != null) {
                        fieldMapBuilder.put((Object)"keyword_plan_ad_group_id", (Object)this.keywordPlanAdGroupId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_KEYWORD_PLAN_AD_GROUP_ID.instantiate(new String[]{"customer_id", this.customerId, "keyword_plan_ad_group_id", this.keywordPlanAdGroupId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            KeywordPlanAdGroupName that = (KeywordPlanAdGroupName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.keywordPlanAdGroupId, that.keywordPlanAdGroupId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.keywordPlanAdGroupId);
    }

    public static class Builder {
        private String customerId;
        private String keywordPlanAdGroupId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getKeywordPlanAdGroupId() {
            return this.keywordPlanAdGroupId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setKeywordPlanAdGroupId(String keywordPlanAdGroupId) {
            this.keywordPlanAdGroupId = keywordPlanAdGroupId;
            return this;
        }

        private Builder(KeywordPlanAdGroupName keywordPlanAdGroupName) {
            this.customerId = keywordPlanAdGroupName.customerId;
            this.keywordPlanAdGroupId = keywordPlanAdGroupName.keywordPlanAdGroupId;
        }

        public KeywordPlanAdGroupName build() {
            return new KeywordPlanAdGroupName(this);
        }
    }
}

