/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeywordPlanCampaignKeywordName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_KEYWORD_PLAN_CAMPAIGN_KEYWORD_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/keywordPlanCampaignKeywords/{keyword_plan_campaign_keyword_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String keywordPlanCampaignKeywordId;

    @Deprecated
    protected KeywordPlanCampaignKeywordName() {
        this.customerId = null;
        this.keywordPlanCampaignKeywordId = null;
    }

    private KeywordPlanCampaignKeywordName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.keywordPlanCampaignKeywordId = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlanCampaignKeywordId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getKeywordPlanCampaignKeywordId() {
        return this.keywordPlanCampaignKeywordId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeywordPlanCampaignKeywordName of(String customerId, String keywordPlanCampaignKeywordId) {
        return KeywordPlanCampaignKeywordName.newBuilder().setCustomerId(customerId).setKeywordPlanCampaignKeywordId(keywordPlanCampaignKeywordId).build();
    }

    public static String format(String customerId, String keywordPlanCampaignKeywordId) {
        return KeywordPlanCampaignKeywordName.newBuilder().setCustomerId(customerId).setKeywordPlanCampaignKeywordId(keywordPlanCampaignKeywordId).build().toString();
    }

    public static KeywordPlanCampaignKeywordName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_KEYWORD_PLAN_CAMPAIGN_KEYWORD_ID.validatedMatch(formattedString, "KeywordPlanCampaignKeywordName.parse: formattedString not in valid format");
        return KeywordPlanCampaignKeywordName.of((String)matchMap.get("customer_id"), (String)matchMap.get("keyword_plan_campaign_keyword_id"));
    }

    public static List<KeywordPlanCampaignKeywordName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanCampaignKeywordName> list = new ArrayList<KeywordPlanCampaignKeywordName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanCampaignKeywordName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanCampaignKeywordName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanCampaignKeywordName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_KEYWORD_PLAN_CAMPAIGN_KEYWORD_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanCampaignKeywordName keywordPlanCampaignKeywordName = this;
            synchronized (keywordPlanCampaignKeywordName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.keywordPlanCampaignKeywordId != null) {
                        fieldMapBuilder.put((Object)"keyword_plan_campaign_keyword_id", (Object)this.keywordPlanCampaignKeywordId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_KEYWORD_PLAN_CAMPAIGN_KEYWORD_ID.instantiate(new String[]{"customer_id", this.customerId, "keyword_plan_campaign_keyword_id", this.keywordPlanCampaignKeywordId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            KeywordPlanCampaignKeywordName that = (KeywordPlanCampaignKeywordName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.keywordPlanCampaignKeywordId, that.keywordPlanCampaignKeywordId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.keywordPlanCampaignKeywordId);
    }

    public static class Builder {
        private String customerId;
        private String keywordPlanCampaignKeywordId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getKeywordPlanCampaignKeywordId() {
            return this.keywordPlanCampaignKeywordId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setKeywordPlanCampaignKeywordId(String keywordPlanCampaignKeywordId) {
            this.keywordPlanCampaignKeywordId = keywordPlanCampaignKeywordId;
            return this;
        }

        private Builder(KeywordPlanCampaignKeywordName keywordPlanCampaignKeywordName) {
            this.customerId = keywordPlanCampaignKeywordName.customerId;
            this.keywordPlanCampaignKeywordId = keywordPlanCampaignKeywordName.keywordPlanCampaignKeywordId;
        }

        public KeywordPlanCampaignKeywordName build() {
            return new KeywordPlanCampaignKeywordName(this);
        }
    }
}

