/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TopicViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/topicViews/{ad_group_id}~{criterion_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String criterionId;

    @Deprecated
    protected TopicViewName() {
        this.customerId = null;
        this.adGroupId = null;
        this.criterionId = null;
    }

    private TopicViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TopicViewName of(String customerId, String adGroupId, String criterionId) {
        return TopicViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCriterionId(criterionId).build();
    }

    public static String format(String customerId, String adGroupId, String criterionId) {
        return TopicViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCriterionId(criterionId).build().toString();
    }

    public static TopicViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID.validatedMatch(formattedString, "TopicViewName.parse: formattedString not in valid format");
        return TopicViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("criterion_id"));
    }

    public static List<TopicViewName> parseList(List<String> formattedStrings) {
        ArrayList<TopicViewName> list = new ArrayList<TopicViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TopicViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TopicViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TopicViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TopicViewName topicViewName = this;
            synchronized (topicViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_CRITERION_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "criterion_id", this.criterionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TopicViewName that = (TopicViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.criterionId, that.criterionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.criterionId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String criterionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        private Builder(TopicViewName topicViewName) {
            this.customerId = topicViewName.customerId;
            this.adGroupId = topicViewName.adGroupId;
            this.criterionId = topicViewName.criterionId;
        }

        public TopicViewName build() {
            return new TopicViewName(this);
        }
    }
}

