/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserInterestName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_USER_INTEREST_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/userInterests/{user_interest_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String userInterestId;

    @Deprecated
    protected UserInterestName() {
        this.customerId = null;
        this.userInterestId = null;
    }

    private UserInterestName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.userInterestId = (String)Preconditions.checkNotNull((Object)builder.getUserInterestId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getUserInterestId() {
        return this.userInterestId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserInterestName of(String customerId, String userInterestId) {
        return UserInterestName.newBuilder().setCustomerId(customerId).setUserInterestId(userInterestId).build();
    }

    public static String format(String customerId, String userInterestId) {
        return UserInterestName.newBuilder().setCustomerId(customerId).setUserInterestId(userInterestId).build().toString();
    }

    public static UserInterestName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_USER_INTEREST_ID.validatedMatch(formattedString, "UserInterestName.parse: formattedString not in valid format");
        return UserInterestName.of((String)matchMap.get("customer_id"), (String)matchMap.get("user_interest_id"));
    }

    public static List<UserInterestName> parseList(List<String> formattedStrings) {
        ArrayList<UserInterestName> list = new ArrayList<UserInterestName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserInterestName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserInterestName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserInterestName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_USER_INTEREST_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserInterestName userInterestName = this;
            synchronized (userInterestName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.userInterestId != null) {
                        fieldMapBuilder.put((Object)"user_interest_id", (Object)this.userInterestId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_USER_INTEREST_ID.instantiate(new String[]{"customer_id", this.customerId, "user_interest_id", this.userInterestId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            UserInterestName that = (UserInterestName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.userInterestId, that.userInterestId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.userInterestId);
    }

    public static class Builder {
        private String customerId;
        private String userInterestId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getUserInterestId() {
            return this.userInterestId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setUserInterestId(String userInterestId) {
            this.userInterestId = userInterestId;
            return this;
        }

        private Builder(UserInterestName userInterestName) {
            this.customerId = userInterestName.customerId;
            this.userInterestId = userInterestName.userInterestId;
        }

        public UserInterestName build() {
            return new UserInterestName(this);
        }
    }
}

