/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.AdGroupSimulation;
import com.google.ads.googleads.v7.resources.AdGroupSimulationName;
import com.google.ads.googleads.v7.services.AdGroupSimulationServiceSettings;
import com.google.ads.googleads.v7.services.GetAdGroupSimulationRequest;
import com.google.ads.googleads.v7.services.stub.AdGroupSimulationServiceStub;
import com.google.ads.googleads.v7.services.stub.AdGroupSimulationServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AdGroupSimulationServiceClient
implements BackgroundResource {
    private final AdGroupSimulationServiceSettings settings;
    private final AdGroupSimulationServiceStub stub;

    public static final AdGroupSimulationServiceClient create() throws IOException {
        return AdGroupSimulationServiceClient.create(AdGroupSimulationServiceSettings.newBuilder().build());
    }

    public static final AdGroupSimulationServiceClient create(AdGroupSimulationServiceSettings settings) throws IOException {
        return new AdGroupSimulationServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdGroupSimulationServiceClient create(AdGroupSimulationServiceStub stub) {
        return new AdGroupSimulationServiceClient(stub);
    }

    protected AdGroupSimulationServiceClient(AdGroupSimulationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupSimulationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdGroupSimulationServiceClient(AdGroupSimulationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupSimulationServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdGroupSimulationServiceStub getStub() {
        return this.stub;
    }

    public final AdGroupSimulation getAdGroupSimulation(AdGroupSimulationName resourceName) {
        GetAdGroupSimulationRequest request = GetAdGroupSimulationRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAdGroupSimulation(request);
    }

    public final AdGroupSimulation getAdGroupSimulation(String resourceName) {
        GetAdGroupSimulationRequest request = GetAdGroupSimulationRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAdGroupSimulation(request);
    }

    public final AdGroupSimulation getAdGroupSimulation(GetAdGroupSimulationRequest request) {
        return (AdGroupSimulation)this.getAdGroupSimulationCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdGroupSimulationRequest, AdGroupSimulation> getAdGroupSimulationCallable() {
        return this.stub.getAdGroupSimulationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

