/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.ConversionCustomVariable;
import com.google.ads.googleads.v7.resources.ConversionCustomVariableName;
import com.google.ads.googleads.v7.services.ConversionCustomVariableOperation;
import com.google.ads.googleads.v7.services.ConversionCustomVariableServiceSettings;
import com.google.ads.googleads.v7.services.GetConversionCustomVariableRequest;
import com.google.ads.googleads.v7.services.MutateConversionCustomVariablesRequest;
import com.google.ads.googleads.v7.services.MutateConversionCustomVariablesResponse;
import com.google.ads.googleads.v7.services.stub.ConversionCustomVariableServiceStub;
import com.google.ads.googleads.v7.services.stub.ConversionCustomVariableServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConversionCustomVariableServiceClient
implements BackgroundResource {
    private final ConversionCustomVariableServiceSettings settings;
    private final ConversionCustomVariableServiceStub stub;

    public static final ConversionCustomVariableServiceClient create() throws IOException {
        return ConversionCustomVariableServiceClient.create(ConversionCustomVariableServiceSettings.newBuilder().build());
    }

    public static final ConversionCustomVariableServiceClient create(ConversionCustomVariableServiceSettings settings) throws IOException {
        return new ConversionCustomVariableServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ConversionCustomVariableServiceClient create(ConversionCustomVariableServiceStub stub) {
        return new ConversionCustomVariableServiceClient(stub);
    }

    protected ConversionCustomVariableServiceClient(ConversionCustomVariableServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversionCustomVariableServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ConversionCustomVariableServiceClient(ConversionCustomVariableServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversionCustomVariableServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConversionCustomVariableServiceStub getStub() {
        return this.stub;
    }

    public final ConversionCustomVariable getConversionCustomVariable(ConversionCustomVariableName resourceName) {
        GetConversionCustomVariableRequest request = GetConversionCustomVariableRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getConversionCustomVariable(request);
    }

    public final ConversionCustomVariable getConversionCustomVariable(String resourceName) {
        GetConversionCustomVariableRequest request = GetConversionCustomVariableRequest.newBuilder().setResourceName(resourceName).build();
        return this.getConversionCustomVariable(request);
    }

    public final ConversionCustomVariable getConversionCustomVariable(GetConversionCustomVariableRequest request) {
        return (ConversionCustomVariable)this.getConversionCustomVariableCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversionCustomVariableRequest, ConversionCustomVariable> getConversionCustomVariableCallable() {
        return this.stub.getConversionCustomVariableCallable();
    }

    public final MutateConversionCustomVariablesResponse mutateConversionCustomVariables(String customerId, List<ConversionCustomVariableOperation> operations) {
        MutateConversionCustomVariablesRequest request = MutateConversionCustomVariablesRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateConversionCustomVariables(request);
    }

    public final MutateConversionCustomVariablesResponse mutateConversionCustomVariables(MutateConversionCustomVariablesRequest request) {
        return (MutateConversionCustomVariablesResponse)this.mutateConversionCustomVariablesCallable().call((Object)request);
    }

    public final UnaryCallable<MutateConversionCustomVariablesRequest, MutateConversionCustomVariablesResponse> mutateConversionCustomVariablesCallable() {
        return this.stub.mutateConversionCustomVariablesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

