/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.CustomerAsset;
import com.google.ads.googleads.v7.resources.CustomerAssetName;
import com.google.ads.googleads.v7.services.CustomerAssetOperation;
import com.google.ads.googleads.v7.services.CustomerAssetServiceSettings;
import com.google.ads.googleads.v7.services.GetCustomerAssetRequest;
import com.google.ads.googleads.v7.services.MutateCustomerAssetsRequest;
import com.google.ads.googleads.v7.services.MutateCustomerAssetsResponse;
import com.google.ads.googleads.v7.services.stub.CustomerAssetServiceStub;
import com.google.ads.googleads.v7.services.stub.CustomerAssetServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomerAssetServiceClient
implements BackgroundResource {
    private final CustomerAssetServiceSettings settings;
    private final CustomerAssetServiceStub stub;

    public static final CustomerAssetServiceClient create() throws IOException {
        return CustomerAssetServiceClient.create(CustomerAssetServiceSettings.newBuilder().build());
    }

    public static final CustomerAssetServiceClient create(CustomerAssetServiceSettings settings) throws IOException {
        return new CustomerAssetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CustomerAssetServiceClient create(CustomerAssetServiceStub stub) {
        return new CustomerAssetServiceClient(stub);
    }

    protected CustomerAssetServiceClient(CustomerAssetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerAssetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CustomerAssetServiceClient(CustomerAssetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerAssetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomerAssetServiceStub getStub() {
        return this.stub;
    }

    public final CustomerAsset getCustomerAsset(CustomerAssetName resourceName) {
        GetCustomerAssetRequest request = GetCustomerAssetRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCustomerAsset(request);
    }

    public final CustomerAsset getCustomerAsset(String resourceName) {
        GetCustomerAssetRequest request = GetCustomerAssetRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCustomerAsset(request);
    }

    public final CustomerAsset getCustomerAsset(GetCustomerAssetRequest request) {
        return (CustomerAsset)this.getCustomerAssetCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomerAssetRequest, CustomerAsset> getCustomerAssetCallable() {
        return this.stub.getCustomerAssetCallable();
    }

    public final MutateCustomerAssetsResponse mutateCustomerAssets(String customerId, List<CustomerAssetOperation> operations) {
        MutateCustomerAssetsRequest request = MutateCustomerAssetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomerAssets(request);
    }

    public final MutateCustomerAssetsResponse mutateCustomerAssets(MutateCustomerAssetsRequest request) {
        return (MutateCustomerAssetsResponse)this.mutateCustomerAssetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerAssetsRequest, MutateCustomerAssetsResponse> mutateCustomerAssetsCallable() {
        return this.stub.mutateCustomerAssetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

