/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.FeedItemSet;
import com.google.ads.googleads.v7.resources.FeedItemSetName;
import com.google.ads.googleads.v7.services.FeedItemSetOperation;
import com.google.ads.googleads.v7.services.FeedItemSetServiceSettings;
import com.google.ads.googleads.v7.services.GetFeedItemSetRequest;
import com.google.ads.googleads.v7.services.MutateFeedItemSetsRequest;
import com.google.ads.googleads.v7.services.MutateFeedItemSetsResponse;
import com.google.ads.googleads.v7.services.stub.FeedItemSetServiceStub;
import com.google.ads.googleads.v7.services.stub.FeedItemSetServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FeedItemSetServiceClient
implements BackgroundResource {
    private final FeedItemSetServiceSettings settings;
    private final FeedItemSetServiceStub stub;

    public static final FeedItemSetServiceClient create() throws IOException {
        return FeedItemSetServiceClient.create(FeedItemSetServiceSettings.newBuilder().build());
    }

    public static final FeedItemSetServiceClient create(FeedItemSetServiceSettings settings) throws IOException {
        return new FeedItemSetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FeedItemSetServiceClient create(FeedItemSetServiceStub stub) {
        return new FeedItemSetServiceClient(stub);
    }

    protected FeedItemSetServiceClient(FeedItemSetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeedItemSetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FeedItemSetServiceClient(FeedItemSetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FeedItemSetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FeedItemSetServiceStub getStub() {
        return this.stub;
    }

    public final FeedItemSet getFeedItemSet(FeedItemSetName resourceName) {
        GetFeedItemSetRequest request = GetFeedItemSetRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getFeedItemSet(request);
    }

    public final FeedItemSet getFeedItemSet(String resourceName) {
        GetFeedItemSetRequest request = GetFeedItemSetRequest.newBuilder().setResourceName(resourceName).build();
        return this.getFeedItemSet(request);
    }

    public final FeedItemSet getFeedItemSet(GetFeedItemSetRequest request) {
        return (FeedItemSet)this.getFeedItemSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeedItemSetRequest, FeedItemSet> getFeedItemSetCallable() {
        return this.stub.getFeedItemSetCallable();
    }

    public final MutateFeedItemSetsResponse mutateFeedItemSets(String customerId, List<FeedItemSetOperation> operations) {
        MutateFeedItemSetsRequest request = MutateFeedItemSetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateFeedItemSets(request);
    }

    public final MutateFeedItemSetsResponse mutateFeedItemSets(MutateFeedItemSetsRequest request) {
        return (MutateFeedItemSetsResponse)this.mutateFeedItemSetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateFeedItemSetsRequest, MutateFeedItemSetsResponse> mutateFeedItemSetsCallable() {
        return this.stub.mutateFeedItemSetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

