/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.SearchTermView;
import com.google.ads.googleads.v7.resources.SearchTermViewName;
import com.google.ads.googleads.v7.services.GetSearchTermViewRequest;
import com.google.ads.googleads.v7.services.SearchTermViewServiceSettings;
import com.google.ads.googleads.v7.services.stub.SearchTermViewServiceStub;
import com.google.ads.googleads.v7.services.stub.SearchTermViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class SearchTermViewServiceClient
implements BackgroundResource {
    private final SearchTermViewServiceSettings settings;
    private final SearchTermViewServiceStub stub;

    public static final SearchTermViewServiceClient create() throws IOException {
        return SearchTermViewServiceClient.create(SearchTermViewServiceSettings.newBuilder().build());
    }

    public static final SearchTermViewServiceClient create(SearchTermViewServiceSettings settings) throws IOException {
        return new SearchTermViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SearchTermViewServiceClient create(SearchTermViewServiceStub stub) {
        return new SearchTermViewServiceClient(stub);
    }

    protected SearchTermViewServiceClient(SearchTermViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SearchTermViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SearchTermViewServiceClient(SearchTermViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SearchTermViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SearchTermViewServiceStub getStub() {
        return this.stub;
    }

    public final SearchTermView getSearchTermView(SearchTermViewName resourceName) {
        GetSearchTermViewRequest request = GetSearchTermViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getSearchTermView(request);
    }

    public final SearchTermView getSearchTermView(String resourceName) {
        GetSearchTermViewRequest request = GetSearchTermViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getSearchTermView(request);
    }

    public final SearchTermView getSearchTermView(GetSearchTermViewRequest request) {
        return (SearchTermView)this.getSearchTermViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetSearchTermViewRequest, SearchTermView> getSearchTermViewCallable() {
        return this.stub.getSearchTermViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

