/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.CustomerExtensionSetting;
import com.google.ads.googleads.v7.services.GetCustomerExtensionSettingRequest;
import com.google.ads.googleads.v7.services.MutateCustomerExtensionSettingsRequest;
import com.google.ads.googleads.v7.services.MutateCustomerExtensionSettingsResponse;
import com.google.ads.googleads.v7.services.stub.CustomerExtensionSettingServiceStub;
import com.google.ads.googleads.v7.services.stub.CustomerExtensionSettingServiceStubSettings;
import com.google.ads.googleads.v7.services.stub.GrpcCustomerExtensionSettingServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcCustomerExtensionSettingServiceStub
extends CustomerExtensionSettingServiceStub {
    private static final MethodDescriptor<GetCustomerExtensionSettingRequest, CustomerExtensionSetting> getCustomerExtensionSettingMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.CustomerExtensionSettingService/GetCustomerExtensionSetting").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCustomerExtensionSettingRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CustomerExtensionSetting.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateCustomerExtensionSettingsRequest, MutateCustomerExtensionSettingsResponse> mutateCustomerExtensionSettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.CustomerExtensionSettingService/MutateCustomerExtensionSettings").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateCustomerExtensionSettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateCustomerExtensionSettingsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetCustomerExtensionSettingRequest, CustomerExtensionSetting> getCustomerExtensionSettingCallable;
    private final UnaryCallable<MutateCustomerExtensionSettingsRequest, MutateCustomerExtensionSettingsResponse> mutateCustomerExtensionSettingsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCustomerExtensionSettingServiceStub create(CustomerExtensionSettingServiceStubSettings settings) throws IOException {
        return new GrpcCustomerExtensionSettingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCustomerExtensionSettingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCustomerExtensionSettingServiceStub(CustomerExtensionSettingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCustomerExtensionSettingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCustomerExtensionSettingServiceStub(CustomerExtensionSettingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCustomerExtensionSettingServiceStub(CustomerExtensionSettingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCustomerExtensionSettingServiceCallableFactory());
    }

    protected GrpcCustomerExtensionSettingServiceStub(CustomerExtensionSettingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getCustomerExtensionSettingTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCustomerExtensionSettingMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetCustomerExtensionSettingRequest>(){

            public Map<String, String> extract(GetCustomerExtensionSettingRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateCustomerExtensionSettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateCustomerExtensionSettingsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateCustomerExtensionSettingsRequest>(){

            public Map<String, String> extract(MutateCustomerExtensionSettingsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getCustomerExtensionSettingCallable = callableFactory.createUnaryCallable(getCustomerExtensionSettingTransportSettings, settings.getCustomerExtensionSettingSettings(), clientContext);
        this.mutateCustomerExtensionSettingsCallable = callableFactory.createUnaryCallable(mutateCustomerExtensionSettingsTransportSettings, settings.mutateCustomerExtensionSettingsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetCustomerExtensionSettingRequest, CustomerExtensionSetting> getCustomerExtensionSettingCallable() {
        return this.getCustomerExtensionSettingCallable;
    }

    @Override
    public UnaryCallable<MutateCustomerExtensionSettingsRequest, MutateCustomerExtensionSettingsResponse> mutateCustomerExtensionSettingsCallable() {
        return this.mutateCustomerExtensionSettingsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

