/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.FeedMapping;
import com.google.ads.googleads.v7.services.GetFeedMappingRequest;
import com.google.ads.googleads.v7.services.MutateFeedMappingsRequest;
import com.google.ads.googleads.v7.services.MutateFeedMappingsResponse;
import com.google.ads.googleads.v7.services.stub.FeedMappingServiceStub;
import com.google.ads.googleads.v7.services.stub.FeedMappingServiceStubSettings;
import com.google.ads.googleads.v7.services.stub.GrpcFeedMappingServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcFeedMappingServiceStub
extends FeedMappingServiceStub {
    private static final MethodDescriptor<GetFeedMappingRequest, FeedMapping> getFeedMappingMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.FeedMappingService/GetFeedMapping").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFeedMappingRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FeedMapping.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateFeedMappingsRequest, MutateFeedMappingsResponse> mutateFeedMappingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.FeedMappingService/MutateFeedMappings").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateFeedMappingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateFeedMappingsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetFeedMappingRequest, FeedMapping> getFeedMappingCallable;
    private final UnaryCallable<MutateFeedMappingsRequest, MutateFeedMappingsResponse> mutateFeedMappingsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFeedMappingServiceStub create(FeedMappingServiceStubSettings settings) throws IOException {
        return new GrpcFeedMappingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFeedMappingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcFeedMappingServiceStub(FeedMappingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFeedMappingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFeedMappingServiceStub(FeedMappingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFeedMappingServiceStub(FeedMappingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFeedMappingServiceCallableFactory());
    }

    protected GrpcFeedMappingServiceStub(FeedMappingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getFeedMappingTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFeedMappingMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetFeedMappingRequest>(){

            public Map<String, String> extract(GetFeedMappingRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateFeedMappingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateFeedMappingsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateFeedMappingsRequest>(){

            public Map<String, String> extract(MutateFeedMappingsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getFeedMappingCallable = callableFactory.createUnaryCallable(getFeedMappingTransportSettings, settings.getFeedMappingSettings(), clientContext);
        this.mutateFeedMappingsCallable = callableFactory.createUnaryCallable(mutateFeedMappingsTransportSettings, settings.mutateFeedMappingsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetFeedMappingRequest, FeedMapping> getFeedMappingCallable() {
        return this.getFeedMappingCallable;
    }

    @Override
    public UnaryCallable<MutateFeedMappingsRequest, MutateFeedMappingsResponse> mutateFeedMappingsCallable() {
        return this.mutateFeedMappingsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

