/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.Label;
import com.google.ads.googleads.v7.services.GetLabelRequest;
import com.google.ads.googleads.v7.services.MutateLabelsRequest;
import com.google.ads.googleads.v7.services.MutateLabelsResponse;
import com.google.ads.googleads.v7.services.stub.GrpcLabelServiceCallableFactory;
import com.google.ads.googleads.v7.services.stub.LabelServiceStub;
import com.google.ads.googleads.v7.services.stub.LabelServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcLabelServiceStub
extends LabelServiceStub {
    private static final MethodDescriptor<GetLabelRequest, Label> getLabelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.LabelService/GetLabel").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLabelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Label.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateLabelsRequest, MutateLabelsResponse> mutateLabelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.LabelService/MutateLabels").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateLabelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateLabelsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetLabelRequest, Label> getLabelCallable;
    private final UnaryCallable<MutateLabelsRequest, MutateLabelsResponse> mutateLabelsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcLabelServiceStub create(LabelServiceStubSettings settings) throws IOException {
        return new GrpcLabelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcLabelServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcLabelServiceStub(LabelServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcLabelServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcLabelServiceStub(LabelServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcLabelServiceStub(LabelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcLabelServiceCallableFactory());
    }

    protected GrpcLabelServiceStub(LabelServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getLabelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLabelMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetLabelRequest>(){

            public Map<String, String> extract(GetLabelRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateLabelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateLabelsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateLabelsRequest>(){

            public Map<String, String> extract(MutateLabelsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getLabelCallable = callableFactory.createUnaryCallable(getLabelTransportSettings, settings.getLabelSettings(), clientContext);
        this.mutateLabelsCallable = callableFactory.createUnaryCallable(mutateLabelsTransportSettings, settings.mutateLabelsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetLabelRequest, Label> getLabelCallable() {
        return this.getLabelCallable;
    }

    @Override
    public UnaryCallable<MutateLabelsRequest, MutateLabelsResponse> mutateLabelsCallable() {
        return this.mutateLabelsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

