/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.SearchTermView;
import com.google.ads.googleads.v7.services.GetSearchTermViewRequest;
import com.google.ads.googleads.v7.services.stub.GrpcSearchTermViewServiceCallableFactory;
import com.google.ads.googleads.v7.services.stub.SearchTermViewServiceStub;
import com.google.ads.googleads.v7.services.stub.SearchTermViewServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcSearchTermViewServiceStub
extends SearchTermViewServiceStub {
    private static final MethodDescriptor<GetSearchTermViewRequest, SearchTermView> getSearchTermViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.SearchTermViewService/GetSearchTermView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSearchTermViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchTermView.getDefaultInstance())).build();
    private final UnaryCallable<GetSearchTermViewRequest, SearchTermView> getSearchTermViewCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSearchTermViewServiceStub create(SearchTermViewServiceStubSettings settings) throws IOException {
        return new GrpcSearchTermViewServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSearchTermViewServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSearchTermViewServiceStub(SearchTermViewServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSearchTermViewServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSearchTermViewServiceStub(SearchTermViewServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSearchTermViewServiceStub(SearchTermViewServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSearchTermViewServiceCallableFactory());
    }

    protected GrpcSearchTermViewServiceStub(SearchTermViewServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getSearchTermViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSearchTermViewMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetSearchTermViewRequest>(){

            public Map<String, String> extract(GetSearchTermViewRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getSearchTermViewCallable = callableFactory.createUnaryCallable(getSearchTermViewTransportSettings, settings.getSearchTermViewSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetSearchTermViewRequest, SearchTermView> getSearchTermViewCallable() {
        return this.getSearchTermViewCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

