/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DistanceViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_PLACEHOLDER_CHAIN_ID_DISTANCE_BUCKET = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/distanceViews/{placeholder_chain_id}~{distance_bucket}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String placeholderChainId;
    private final String distanceBucket;

    @Deprecated
    protected DistanceViewName() {
        this.customerId = null;
        this.placeholderChainId = null;
        this.distanceBucket = null;
    }

    private DistanceViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.placeholderChainId = (String)Preconditions.checkNotNull((Object)builder.getPlaceholderChainId());
        this.distanceBucket = (String)Preconditions.checkNotNull((Object)builder.getDistanceBucket());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getPlaceholderChainId() {
        return this.placeholderChainId;
    }

    public String getDistanceBucket() {
        return this.distanceBucket;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DistanceViewName of(String customerId, String placeholderChainId, String distanceBucket) {
        return DistanceViewName.newBuilder().setCustomerId(customerId).setPlaceholderChainId(placeholderChainId).setDistanceBucket(distanceBucket).build();
    }

    public static String format(String customerId, String placeholderChainId, String distanceBucket) {
        return DistanceViewName.newBuilder().setCustomerId(customerId).setPlaceholderChainId(placeholderChainId).setDistanceBucket(distanceBucket).build().toString();
    }

    public static DistanceViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_PLACEHOLDER_CHAIN_ID_DISTANCE_BUCKET.validatedMatch(formattedString, "DistanceViewName.parse: formattedString not in valid format");
        return DistanceViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("placeholder_chain_id"), (String)matchMap.get("distance_bucket"));
    }

    public static List<DistanceViewName> parseList(List<String> formattedStrings) {
        ArrayList<DistanceViewName> list = new ArrayList<DistanceViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DistanceViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DistanceViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DistanceViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_PLACEHOLDER_CHAIN_ID_DISTANCE_BUCKET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DistanceViewName distanceViewName = this;
            synchronized (distanceViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.placeholderChainId != null) {
                        fieldMapBuilder.put((Object)"placeholder_chain_id", (Object)this.placeholderChainId);
                    }
                    if (this.distanceBucket != null) {
                        fieldMapBuilder.put((Object)"distance_bucket", (Object)this.distanceBucket);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_PLACEHOLDER_CHAIN_ID_DISTANCE_BUCKET.instantiate(new String[]{"customer_id", this.customerId, "placeholder_chain_id", this.placeholderChainId, "distance_bucket", this.distanceBucket});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DistanceViewName that = (DistanceViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.placeholderChainId, that.placeholderChainId) && Objects.equals(this.distanceBucket, that.distanceBucket);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.placeholderChainId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.distanceBucket);
    }

    public static class Builder {
        private String customerId;
        private String placeholderChainId;
        private String distanceBucket;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getPlaceholderChainId() {
            return this.placeholderChainId;
        }

        public String getDistanceBucket() {
            return this.distanceBucket;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setPlaceholderChainId(String placeholderChainId) {
            this.placeholderChainId = placeholderChainId;
            return this;
        }

        public Builder setDistanceBucket(String distanceBucket) {
            this.distanceBucket = distanceBucket;
            return this;
        }

        private Builder(DistanceViewName distanceViewName) {
            this.customerId = distanceViewName.customerId;
            this.placeholderChainId = distanceViewName.placeholderChainId;
            this.distanceBucket = distanceViewName.distanceBucket;
        }

        public DistanceViewName build() {
            return new DistanceViewName(this);
        }
    }
}

