/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MerchantCenterLinkName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_MERCHANT_CENTER_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/merchantCenterLinks/{merchant_center_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String merchantCenterId;

    @Deprecated
    protected MerchantCenterLinkName() {
        this.customerId = null;
        this.merchantCenterId = null;
    }

    private MerchantCenterLinkName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.merchantCenterId = (String)Preconditions.checkNotNull((Object)builder.getMerchantCenterId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getMerchantCenterId() {
        return this.merchantCenterId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MerchantCenterLinkName of(String customerId, String merchantCenterId) {
        return MerchantCenterLinkName.newBuilder().setCustomerId(customerId).setMerchantCenterId(merchantCenterId).build();
    }

    public static String format(String customerId, String merchantCenterId) {
        return MerchantCenterLinkName.newBuilder().setCustomerId(customerId).setMerchantCenterId(merchantCenterId).build().toString();
    }

    public static MerchantCenterLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_MERCHANT_CENTER_ID.validatedMatch(formattedString, "MerchantCenterLinkName.parse: formattedString not in valid format");
        return MerchantCenterLinkName.of((String)matchMap.get("customer_id"), (String)matchMap.get("merchant_center_id"));
    }

    public static List<MerchantCenterLinkName> parseList(List<String> formattedStrings) {
        ArrayList<MerchantCenterLinkName> list = new ArrayList<MerchantCenterLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MerchantCenterLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MerchantCenterLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MerchantCenterLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_MERCHANT_CENTER_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MerchantCenterLinkName merchantCenterLinkName = this;
            synchronized (merchantCenterLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.merchantCenterId != null) {
                        fieldMapBuilder.put((Object)"merchant_center_id", (Object)this.merchantCenterId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_MERCHANT_CENTER_ID.instantiate(new String[]{"customer_id", this.customerId, "merchant_center_id", this.merchantCenterId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MerchantCenterLinkName that = (MerchantCenterLinkName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.merchantCenterId, that.merchantCenterId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.merchantCenterId);
    }

    public static class Builder {
        private String customerId;
        private String merchantCenterId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getMerchantCenterId() {
            return this.merchantCenterId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setMerchantCenterId(String merchantCenterId) {
            this.merchantCenterId = merchantCenterId;
            return this;
        }

        private Builder(MerchantCenterLinkName merchantCenterLinkName) {
            this.customerId = merchantCenterLinkName.customerId;
            this.merchantCenterId = merchantCenterLinkName.merchantCenterId;
        }

        public MerchantCenterLinkName build() {
            return new MerchantCenterLinkName(this);
        }
    }
}

