/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserListName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_USER_LIST_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/userLists/{user_list_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String userListId;

    @Deprecated
    protected UserListName() {
        this.customerId = null;
        this.userListId = null;
    }

    private UserListName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.userListId = (String)Preconditions.checkNotNull((Object)builder.getUserListId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getUserListId() {
        return this.userListId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserListName of(String customerId, String userListId) {
        return UserListName.newBuilder().setCustomerId(customerId).setUserListId(userListId).build();
    }

    public static String format(String customerId, String userListId) {
        return UserListName.newBuilder().setCustomerId(customerId).setUserListId(userListId).build().toString();
    }

    public static UserListName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_USER_LIST_ID.validatedMatch(formattedString, "UserListName.parse: formattedString not in valid format");
        return UserListName.of((String)matchMap.get("customer_id"), (String)matchMap.get("user_list_id"));
    }

    public static List<UserListName> parseList(List<String> formattedStrings) {
        ArrayList<UserListName> list = new ArrayList<UserListName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserListName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserListName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserListName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_USER_LIST_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserListName userListName = this;
            synchronized (userListName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.userListId != null) {
                        fieldMapBuilder.put((Object)"user_list_id", (Object)this.userListId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_USER_LIST_ID.instantiate(new String[]{"customer_id", this.customerId, "user_list_id", this.userListId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            UserListName that = (UserListName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.userListId, that.userListId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.userListId);
    }

    public static class Builder {
        private String customerId;
        private String userListId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getUserListId() {
            return this.userListId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setUserListId(String userListId) {
            this.userListId = userListId;
            return this;
        }

        private Builder(UserListName userListName) {
            this.customerId = userListName.customerId;
            this.userListId = userListName.userListId;
        }

        public UserListName build() {
            return new UserListName(this);
        }
    }
}

