/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.resources.AdGroupCriterionLabel;
import com.google.ads.googleads.v6.resources.AdGroupCriterionLabelName;
import com.google.ads.googleads.v6.services.AdGroupCriterionLabelOperation;
import com.google.ads.googleads.v6.services.AdGroupCriterionLabelServiceSettings;
import com.google.ads.googleads.v6.services.GetAdGroupCriterionLabelRequest;
import com.google.ads.googleads.v6.services.MutateAdGroupCriterionLabelsRequest;
import com.google.ads.googleads.v6.services.MutateAdGroupCriterionLabelsResponse;
import com.google.ads.googleads.v6.services.stub.AdGroupCriterionLabelServiceStub;
import com.google.ads.googleads.v6.services.stub.AdGroupCriterionLabelServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupCriterionLabelServiceClient
implements BackgroundResource {
    private final AdGroupCriterionLabelServiceSettings settings;
    private final AdGroupCriterionLabelServiceStub stub;

    public static final AdGroupCriterionLabelServiceClient create() throws IOException {
        return AdGroupCriterionLabelServiceClient.create(AdGroupCriterionLabelServiceSettings.newBuilder().build());
    }

    public static final AdGroupCriterionLabelServiceClient create(AdGroupCriterionLabelServiceSettings settings) throws IOException {
        return new AdGroupCriterionLabelServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdGroupCriterionLabelServiceClient create(AdGroupCriterionLabelServiceStub stub) {
        return new AdGroupCriterionLabelServiceClient(stub);
    }

    protected AdGroupCriterionLabelServiceClient(AdGroupCriterionLabelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupCriterionLabelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdGroupCriterionLabelServiceClient(AdGroupCriterionLabelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupCriterionLabelServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdGroupCriterionLabelServiceStub getStub() {
        return this.stub;
    }

    public final AdGroupCriterionLabel getAdGroupCriterionLabel(AdGroupCriterionLabelName resourceName) {
        GetAdGroupCriterionLabelRequest request = GetAdGroupCriterionLabelRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAdGroupCriterionLabel(request);
    }

    public final AdGroupCriterionLabel getAdGroupCriterionLabel(String resourceName) {
        GetAdGroupCriterionLabelRequest request = GetAdGroupCriterionLabelRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAdGroupCriterionLabel(request);
    }

    public final AdGroupCriterionLabel getAdGroupCriterionLabel(GetAdGroupCriterionLabelRequest request) {
        return (AdGroupCriterionLabel)this.getAdGroupCriterionLabelCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdGroupCriterionLabelRequest, AdGroupCriterionLabel> getAdGroupCriterionLabelCallable() {
        return this.stub.getAdGroupCriterionLabelCallable();
    }

    public final MutateAdGroupCriterionLabelsResponse mutateAdGroupCriterionLabels(String customerId, List<AdGroupCriterionLabelOperation> operations) {
        MutateAdGroupCriterionLabelsRequest request = MutateAdGroupCriterionLabelsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupCriterionLabels(request);
    }

    public final MutateAdGroupCriterionLabelsResponse mutateAdGroupCriterionLabels(MutateAdGroupCriterionLabelsRequest request) {
        return (MutateAdGroupCriterionLabelsResponse)this.mutateAdGroupCriterionLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupCriterionLabelsRequest, MutateAdGroupCriterionLabelsResponse> mutateAdGroupCriterionLabelsCallable() {
        return this.stub.mutateAdGroupCriterionLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

