/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.resources.CurrencyConstant;
import com.google.ads.googleads.v6.resources.CurrencyConstantName;
import com.google.ads.googleads.v6.services.CurrencyConstantServiceSettings;
import com.google.ads.googleads.v6.services.GetCurrencyConstantRequest;
import com.google.ads.googleads.v6.services.stub.CurrencyConstantServiceStub;
import com.google.ads.googleads.v6.services.stub.CurrencyConstantServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CurrencyConstantServiceClient
implements BackgroundResource {
    private final CurrencyConstantServiceSettings settings;
    private final CurrencyConstantServiceStub stub;

    public static final CurrencyConstantServiceClient create() throws IOException {
        return CurrencyConstantServiceClient.create(CurrencyConstantServiceSettings.newBuilder().build());
    }

    public static final CurrencyConstantServiceClient create(CurrencyConstantServiceSettings settings) throws IOException {
        return new CurrencyConstantServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CurrencyConstantServiceClient create(CurrencyConstantServiceStub stub) {
        return new CurrencyConstantServiceClient(stub);
    }

    protected CurrencyConstantServiceClient(CurrencyConstantServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CurrencyConstantServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CurrencyConstantServiceClient(CurrencyConstantServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CurrencyConstantServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CurrencyConstantServiceStub getStub() {
        return this.stub;
    }

    public final CurrencyConstant getCurrencyConstant(CurrencyConstantName resourceName) {
        GetCurrencyConstantRequest request = GetCurrencyConstantRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCurrencyConstant(request);
    }

    public final CurrencyConstant getCurrencyConstant(String resourceName) {
        GetCurrencyConstantRequest request = GetCurrencyConstantRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCurrencyConstant(request);
    }

    public final CurrencyConstant getCurrencyConstant(GetCurrencyConstantRequest request) {
        return (CurrencyConstant)this.getCurrencyConstantCallable().call((Object)request);
    }

    public final UnaryCallable<GetCurrencyConstantRequest, CurrencyConstant> getCurrencyConstantCallable() {
        return this.stub.getCurrencyConstantCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

