/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.resources.CustomerUserAccessInvitation;
import com.google.ads.googleads.v6.resources.CustomerUserAccessInvitationName;
import com.google.ads.googleads.v6.services.CustomerUserAccessInvitationOperation;
import com.google.ads.googleads.v6.services.CustomerUserAccessInvitationServiceSettings;
import com.google.ads.googleads.v6.services.GetCustomerUserAccessInvitationRequest;
import com.google.ads.googleads.v6.services.MutateCustomerUserAccessInvitationRequest;
import com.google.ads.googleads.v6.services.MutateCustomerUserAccessInvitationResponse;
import com.google.ads.googleads.v6.services.stub.CustomerUserAccessInvitationServiceStub;
import com.google.ads.googleads.v6.services.stub.CustomerUserAccessInvitationServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CustomerUserAccessInvitationServiceClient
implements BackgroundResource {
    private final CustomerUserAccessInvitationServiceSettings settings;
    private final CustomerUserAccessInvitationServiceStub stub;

    public static final CustomerUserAccessInvitationServiceClient create() throws IOException {
        return CustomerUserAccessInvitationServiceClient.create(CustomerUserAccessInvitationServiceSettings.newBuilder().build());
    }

    public static final CustomerUserAccessInvitationServiceClient create(CustomerUserAccessInvitationServiceSettings settings) throws IOException {
        return new CustomerUserAccessInvitationServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CustomerUserAccessInvitationServiceClient create(CustomerUserAccessInvitationServiceStub stub) {
        return new CustomerUserAccessInvitationServiceClient(stub);
    }

    protected CustomerUserAccessInvitationServiceClient(CustomerUserAccessInvitationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerUserAccessInvitationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CustomerUserAccessInvitationServiceClient(CustomerUserAccessInvitationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerUserAccessInvitationServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomerUserAccessInvitationServiceStub getStub() {
        return this.stub;
    }

    public final CustomerUserAccessInvitation getCustomerUserAccessInvitation(CustomerUserAccessInvitationName resourceName) {
        GetCustomerUserAccessInvitationRequest request = GetCustomerUserAccessInvitationRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCustomerUserAccessInvitation(request);
    }

    public final CustomerUserAccessInvitation getCustomerUserAccessInvitation(String resourceName) {
        GetCustomerUserAccessInvitationRequest request = GetCustomerUserAccessInvitationRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCustomerUserAccessInvitation(request);
    }

    public final CustomerUserAccessInvitation getCustomerUserAccessInvitation(GetCustomerUserAccessInvitationRequest request) {
        return (CustomerUserAccessInvitation)this.getCustomerUserAccessInvitationCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomerUserAccessInvitationRequest, CustomerUserAccessInvitation> getCustomerUserAccessInvitationCallable() {
        return this.stub.getCustomerUserAccessInvitationCallable();
    }

    public final MutateCustomerUserAccessInvitationResponse mutateCustomerUserAccessInvitation(String customerId, CustomerUserAccessInvitationOperation operation) {
        MutateCustomerUserAccessInvitationRequest request = MutateCustomerUserAccessInvitationRequest.newBuilder().setCustomerId(customerId).setOperation(operation).build();
        return this.mutateCustomerUserAccessInvitation(request);
    }

    public final MutateCustomerUserAccessInvitationResponse mutateCustomerUserAccessInvitation(MutateCustomerUserAccessInvitationRequest request) {
        return (MutateCustomerUserAccessInvitationResponse)this.mutateCustomerUserAccessInvitationCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerUserAccessInvitationRequest, MutateCustomerUserAccessInvitationResponse> mutateCustomerUserAccessInvitationCallable() {
        return this.stub.mutateCustomerUserAccessInvitationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

