/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.services.GoogleAdsRow;
import com.google.ads.googleads.v6.services.GoogleAdsServiceSettings;
import com.google.ads.googleads.v6.services.MutateGoogleAdsRequest;
import com.google.ads.googleads.v6.services.MutateGoogleAdsResponse;
import com.google.ads.googleads.v6.services.MutateOperation;
import com.google.ads.googleads.v6.services.SearchGoogleAdsRequest;
import com.google.ads.googleads.v6.services.SearchGoogleAdsResponse;
import com.google.ads.googleads.v6.services.SearchGoogleAdsStreamRequest;
import com.google.ads.googleads.v6.services.SearchGoogleAdsStreamResponse;
import com.google.ads.googleads.v6.services.stub.GoogleAdsServiceStub;
import com.google.ads.googleads.v6.services.stub.GoogleAdsServiceStubSettings;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GoogleAdsServiceClient
implements BackgroundResource {
    private final GoogleAdsServiceSettings settings;
    private final GoogleAdsServiceStub stub;

    public static final GoogleAdsServiceClient create() throws IOException {
        return GoogleAdsServiceClient.create(GoogleAdsServiceSettings.newBuilder().build());
    }

    public static final GoogleAdsServiceClient create(GoogleAdsServiceSettings settings) throws IOException {
        return new GoogleAdsServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GoogleAdsServiceClient create(GoogleAdsServiceStub stub) {
        return new GoogleAdsServiceClient(stub);
    }

    protected GoogleAdsServiceClient(GoogleAdsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GoogleAdsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GoogleAdsServiceClient(GoogleAdsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GoogleAdsServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GoogleAdsServiceStub getStub() {
        return this.stub;
    }

    public final SearchPagedResponse search(String customerId, String query) {
        SearchGoogleAdsRequest request = SearchGoogleAdsRequest.newBuilder().setCustomerId(customerId).setQuery(query).build();
        return this.search(request);
    }

    public final SearchPagedResponse search(SearchGoogleAdsRequest request) {
        return (SearchPagedResponse)((Object)this.searchPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchGoogleAdsRequest, SearchPagedResponse> searchPagedCallable() {
        return this.stub.searchPagedCallable();
    }

    public final UnaryCallable<SearchGoogleAdsRequest, SearchGoogleAdsResponse> searchCallable() {
        return this.stub.searchCallable();
    }

    public final ServerStreamingCallable<SearchGoogleAdsStreamRequest, SearchGoogleAdsStreamResponse> searchStreamCallable() {
        return this.stub.searchStreamCallable();
    }

    public final MutateGoogleAdsResponse mutate(String customerId, List<MutateOperation> mutateOperations) {
        MutateGoogleAdsRequest request = MutateGoogleAdsRequest.newBuilder().setCustomerId(customerId).addAllMutateOperations(mutateOperations).build();
        return this.mutate(request);
    }

    public final MutateGoogleAdsResponse mutate(MutateGoogleAdsRequest request) {
        return (MutateGoogleAdsResponse)this.mutateCallable().call((Object)request);
    }

    public final UnaryCallable<MutateGoogleAdsRequest, MutateGoogleAdsResponse> mutateCallable() {
        return this.stub.mutateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchGoogleAdsRequest, SearchGoogleAdsResponse, GoogleAdsRow, SearchPage, SearchFixedSizeCollection> {
        private SearchFixedSizeCollection(List<SearchPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchFixedSizeCollection createEmptyCollection() {
            return new SearchFixedSizeCollection(null, 0);
        }

        protected SearchFixedSizeCollection createCollection(List<SearchPage> pages, int collectionSize) {
            return new SearchFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchPage
    extends AbstractPage<SearchGoogleAdsRequest, SearchGoogleAdsResponse, GoogleAdsRow, SearchPage> {
        private SearchPage(PageContext<SearchGoogleAdsRequest, SearchGoogleAdsResponse, GoogleAdsRow> context, SearchGoogleAdsResponse response) {
            super(context, (Object)response);
        }

        private static SearchPage createEmptyPage() {
            return new SearchPage(null, null);
        }

        protected SearchPage createPage(PageContext<SearchGoogleAdsRequest, SearchGoogleAdsResponse, GoogleAdsRow> context, SearchGoogleAdsResponse response) {
            return new SearchPage(context, response);
        }

        public ApiFuture<SearchPage> createPageAsync(PageContext<SearchGoogleAdsRequest, SearchGoogleAdsResponse, GoogleAdsRow> context, ApiFuture<SearchGoogleAdsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchPagedResponse
    extends AbstractPagedListResponse<SearchGoogleAdsRequest, SearchGoogleAdsResponse, GoogleAdsRow, SearchPage, SearchFixedSizeCollection> {
        public static ApiFuture<SearchPagedResponse> createAsync(PageContext<SearchGoogleAdsRequest, SearchGoogleAdsResponse, GoogleAdsRow> context, ApiFuture<SearchGoogleAdsResponse> futureResponse) {
            ApiFuture<SearchPage> futurePage = SearchPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchPage, SearchPagedResponse>(){

                public SearchPagedResponse apply(SearchPage input) {
                    return new SearchPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchPagedResponse(SearchPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchFixedSizeCollection.createEmptyCollection());
        }
    }
}

