/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.resources.TopicView;
import com.google.ads.googleads.v6.resources.TopicViewName;
import com.google.ads.googleads.v6.services.GetTopicViewRequest;
import com.google.ads.googleads.v6.services.TopicViewServiceSettings;
import com.google.ads.googleads.v6.services.stub.TopicViewServiceStub;
import com.google.ads.googleads.v6.services.stub.TopicViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class TopicViewServiceClient
implements BackgroundResource {
    private final TopicViewServiceSettings settings;
    private final TopicViewServiceStub stub;

    public static final TopicViewServiceClient create() throws IOException {
        return TopicViewServiceClient.create(TopicViewServiceSettings.newBuilder().build());
    }

    public static final TopicViewServiceClient create(TopicViewServiceSettings settings) throws IOException {
        return new TopicViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TopicViewServiceClient create(TopicViewServiceStub stub) {
        return new TopicViewServiceClient(stub);
    }

    protected TopicViewServiceClient(TopicViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TopicViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TopicViewServiceClient(TopicViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TopicViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TopicViewServiceStub getStub() {
        return this.stub;
    }

    public final TopicView getTopicView(TopicViewName resourceName) {
        GetTopicViewRequest request = GetTopicViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getTopicView(request);
    }

    public final TopicView getTopicView(String resourceName) {
        GetTopicViewRequest request = GetTopicViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getTopicView(request);
    }

    public final TopicView getTopicView(GetTopicViewRequest request) {
        return (TopicView)this.getTopicViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetTopicViewRequest, TopicView> getTopicViewCallable() {
        return this.stub.getTopicViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

