/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services;

import com.google.ads.googleads.v6.resources.Video;
import com.google.ads.googleads.v6.resources.VideoName;
import com.google.ads.googleads.v6.services.GetVideoRequest;
import com.google.ads.googleads.v6.services.VideoServiceSettings;
import com.google.ads.googleads.v6.services.stub.VideoServiceStub;
import com.google.ads.googleads.v6.services.stub.VideoServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class VideoServiceClient
implements BackgroundResource {
    private final VideoServiceSettings settings;
    private final VideoServiceStub stub;

    public static final VideoServiceClient create() throws IOException {
        return VideoServiceClient.create(VideoServiceSettings.newBuilder().build());
    }

    public static final VideoServiceClient create(VideoServiceSettings settings) throws IOException {
        return new VideoServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final VideoServiceClient create(VideoServiceStub stub) {
        return new VideoServiceClient(stub);
    }

    protected VideoServiceClient(VideoServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VideoServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected VideoServiceClient(VideoServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final VideoServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VideoServiceStub getStub() {
        return this.stub;
    }

    public final Video getVideo(VideoName resourceName) {
        GetVideoRequest request = GetVideoRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getVideo(request);
    }

    public final Video getVideo(String resourceName) {
        GetVideoRequest request = GetVideoRequest.newBuilder().setResourceName(resourceName).build();
        return this.getVideo(request);
    }

    public final Video getVideo(GetVideoRequest request) {
        return (Video)this.getVideoCallable().call((Object)request);
    }

    public final UnaryCallable<GetVideoRequest, Video> getVideoCallable() {
        return this.stub.getVideoCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

