/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services.stub;

import com.google.ads.googleads.v6.resources.ClickView;
import com.google.ads.googleads.v6.services.GetClickViewRequest;
import com.google.ads.googleads.v6.services.stub.ClickViewServiceStub;
import com.google.ads.googleads.v6.services.stub.ClickViewServiceStubSettings;
import com.google.ads.googleads.v6.services.stub.GrpcClickViewServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcClickViewServiceStub
extends ClickViewServiceStub {
    private static final MethodDescriptor<GetClickViewRequest, ClickView> getClickViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.ClickViewService/GetClickView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetClickViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ClickView.getDefaultInstance())).build();
    private final UnaryCallable<GetClickViewRequest, ClickView> getClickViewCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcClickViewServiceStub create(ClickViewServiceStubSettings settings) throws IOException {
        return new GrpcClickViewServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcClickViewServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcClickViewServiceStub(ClickViewServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcClickViewServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcClickViewServiceStub(ClickViewServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcClickViewServiceStub(ClickViewServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcClickViewServiceCallableFactory());
    }

    protected GrpcClickViewServiceStub(ClickViewServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getClickViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getClickViewMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetClickViewRequest>(){

            public Map<String, String> extract(GetClickViewRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getClickViewCallable = callableFactory.createUnaryCallable(getClickViewTransportSettings, settings.getClickViewSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetClickViewRequest, ClickView> getClickViewCallable() {
        return this.getClickViewCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

