/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services.stub;

import com.google.ads.googleads.v6.resources.CustomAudience;
import com.google.ads.googleads.v6.services.GetCustomAudienceRequest;
import com.google.ads.googleads.v6.services.MutateCustomAudiencesRequest;
import com.google.ads.googleads.v6.services.MutateCustomAudiencesResponse;
import com.google.ads.googleads.v6.services.stub.CustomAudienceServiceStub;
import com.google.ads.googleads.v6.services.stub.CustomAudienceServiceStubSettings;
import com.google.ads.googleads.v6.services.stub.GrpcCustomAudienceServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcCustomAudienceServiceStub
extends CustomAudienceServiceStub {
    private static final MethodDescriptor<GetCustomAudienceRequest, CustomAudience> getCustomAudienceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.CustomAudienceService/GetCustomAudience").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCustomAudienceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CustomAudience.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateCustomAudiencesRequest, MutateCustomAudiencesResponse> mutateCustomAudiencesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.CustomAudienceService/MutateCustomAudiences").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateCustomAudiencesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateCustomAudiencesResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetCustomAudienceRequest, CustomAudience> getCustomAudienceCallable;
    private final UnaryCallable<MutateCustomAudiencesRequest, MutateCustomAudiencesResponse> mutateCustomAudiencesCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCustomAudienceServiceStub create(CustomAudienceServiceStubSettings settings) throws IOException {
        return new GrpcCustomAudienceServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCustomAudienceServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCustomAudienceServiceStub(CustomAudienceServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCustomAudienceServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCustomAudienceServiceStub(CustomAudienceServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCustomAudienceServiceStub(CustomAudienceServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCustomAudienceServiceCallableFactory());
    }

    protected GrpcCustomAudienceServiceStub(CustomAudienceServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getCustomAudienceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCustomAudienceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetCustomAudienceRequest>(){

            public Map<String, String> extract(GetCustomAudienceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateCustomAudiencesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateCustomAudiencesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateCustomAudiencesRequest>(){

            public Map<String, String> extract(MutateCustomAudiencesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getCustomAudienceCallable = callableFactory.createUnaryCallable(getCustomAudienceTransportSettings, settings.getCustomAudienceSettings(), clientContext);
        this.mutateCustomAudiencesCallable = callableFactory.createUnaryCallable(mutateCustomAudiencesTransportSettings, settings.mutateCustomAudiencesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetCustomAudienceRequest, CustomAudience> getCustomAudienceCallable() {
        return this.getCustomAudienceCallable;
    }

    @Override
    public UnaryCallable<MutateCustomAudiencesRequest, MutateCustomAudiencesResponse> mutateCustomAudiencesCallable() {
        return this.mutateCustomAudiencesCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

