/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v6.services.stub;

import com.google.ads.googleads.v6.resources.ProductGroupView;
import com.google.ads.googleads.v6.services.GetProductGroupViewRequest;
import com.google.ads.googleads.v6.services.stub.GrpcProductGroupViewServiceCallableFactory;
import com.google.ads.googleads.v6.services.stub.ProductGroupViewServiceStub;
import com.google.ads.googleads.v6.services.stub.ProductGroupViewServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcProductGroupViewServiceStub
extends ProductGroupViewServiceStub {
    private static final MethodDescriptor<GetProductGroupViewRequest, ProductGroupView> getProductGroupViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v6.services.ProductGroupViewService/GetProductGroupView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProductGroupViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProductGroupView.getDefaultInstance())).build();
    private final UnaryCallable<GetProductGroupViewRequest, ProductGroupView> getProductGroupViewCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProductGroupViewServiceStub create(ProductGroupViewServiceStubSettings settings) throws IOException {
        return new GrpcProductGroupViewServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProductGroupViewServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcProductGroupViewServiceStub(ProductGroupViewServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProductGroupViewServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProductGroupViewServiceStub(ProductGroupViewServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProductGroupViewServiceStub(ProductGroupViewServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProductGroupViewServiceCallableFactory());
    }

    protected GrpcProductGroupViewServiceStub(ProductGroupViewServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getProductGroupViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProductGroupViewMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetProductGroupViewRequest>(){

            public Map<String, String> extract(GetProductGroupViewRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getProductGroupViewCallable = callableFactory.createUnaryCallable(getProductGroupViewTransportSettings, settings.getProductGroupViewSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetProductGroupViewRequest, ProductGroupView> getProductGroupViewCallable() {
        return this.getProductGroupViewCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

