/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupExtensionSettingName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_EXTENSION_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupExtensionSettings/{ad_group_id}~{extension_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String extensionType;

    @Deprecated
    protected AdGroupExtensionSettingName() {
        this.customerId = null;
        this.adGroupId = null;
        this.extensionType = null;
    }

    private AdGroupExtensionSettingName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.extensionType = (String)Preconditions.checkNotNull((Object)builder.getExtensionType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getExtensionType() {
        return this.extensionType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupExtensionSettingName of(String customerId, String adGroupId, String extensionType) {
        return AdGroupExtensionSettingName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setExtensionType(extensionType).build();
    }

    public static String format(String customerId, String adGroupId, String extensionType) {
        return AdGroupExtensionSettingName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setExtensionType(extensionType).build().toString();
    }

    public static AdGroupExtensionSettingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_EXTENSION_TYPE.validatedMatch(formattedString, "AdGroupExtensionSettingName.parse: formattedString not in valid format");
        return AdGroupExtensionSettingName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("extension_type"));
    }

    public static List<AdGroupExtensionSettingName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupExtensionSettingName> list = new ArrayList<AdGroupExtensionSettingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupExtensionSettingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupExtensionSettingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupExtensionSettingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_EXTENSION_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupExtensionSettingName adGroupExtensionSettingName = this;
            synchronized (adGroupExtensionSettingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.extensionType != null) {
                        fieldMapBuilder.put((Object)"extension_type", (Object)this.extensionType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_EXTENSION_TYPE.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "extension_type", this.extensionType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AdGroupExtensionSettingName that = (AdGroupExtensionSettingName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.extensionType, that.extensionType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.extensionType);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String extensionType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getExtensionType() {
            return this.extensionType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setExtensionType(String extensionType) {
            this.extensionType = extensionType;
            return this;
        }

        private Builder(AdGroupExtensionSettingName adGroupExtensionSettingName) {
            this.customerId = adGroupExtensionSettingName.customerId;
            this.adGroupId = adGroupExtensionSettingName.adGroupId;
            this.extensionType = adGroupExtensionSettingName.extensionType;
        }

        public AdGroupExtensionSettingName build() {
            return new AdGroupExtensionSettingName(this);
        }
    }
}

