/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerNegativeCriterionName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CRITERION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerNegativeCriteria/{criterion_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String criterionId;

    @Deprecated
    protected CustomerNegativeCriterionName() {
        this.customerId = null;
        this.criterionId = null;
    }

    private CustomerNegativeCriterionName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerNegativeCriterionName of(String customerId, String criterionId) {
        return CustomerNegativeCriterionName.newBuilder().setCustomerId(customerId).setCriterionId(criterionId).build();
    }

    public static String format(String customerId, String criterionId) {
        return CustomerNegativeCriterionName.newBuilder().setCustomerId(customerId).setCriterionId(criterionId).build().toString();
    }

    public static CustomerNegativeCriterionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CRITERION_ID.validatedMatch(formattedString, "CustomerNegativeCriterionName.parse: formattedString not in valid format");
        return CustomerNegativeCriterionName.of((String)matchMap.get("customer_id"), (String)matchMap.get("criterion_id"));
    }

    public static List<CustomerNegativeCriterionName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerNegativeCriterionName> list = new ArrayList<CustomerNegativeCriterionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerNegativeCriterionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerNegativeCriterionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerNegativeCriterionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CRITERION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerNegativeCriterionName customerNegativeCriterionName = this;
            synchronized (customerNegativeCriterionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CRITERION_ID.instantiate(new String[]{"customer_id", this.customerId, "criterion_id", this.criterionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomerNegativeCriterionName that = (CustomerNegativeCriterionName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.criterionId, that.criterionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.criterionId);
    }

    public static class Builder {
        private String customerId;
        private String criterionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        private Builder(CustomerNegativeCriterionName customerNegativeCriterionName) {
            this.customerId = customerNegativeCriterionName.customerId;
            this.criterionId = customerNegativeCriterionName.criterionId;
        }

        public CustomerNegativeCriterionName build() {
            return new CustomerNegativeCriterionName(this);
        }
    }
}

