/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeedItemTargetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_FEED_ID_FEED_ITEM_ID_FEED_ITEM_TARGET_TYPE_FEED_ITEM_TARGET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/feedItemTargets/{feed_id}~{feed_item_id}~{feed_item_target_type}~{feed_item_target_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String feedId;
    private final String feedItemId;
    private final String feedItemTargetType;
    private final String feedItemTargetId;

    @Deprecated
    protected FeedItemTargetName() {
        this.customerId = null;
        this.feedId = null;
        this.feedItemId = null;
        this.feedItemTargetType = null;
        this.feedItemTargetId = null;
    }

    private FeedItemTargetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.feedId = (String)Preconditions.checkNotNull((Object)builder.getFeedId());
        this.feedItemId = (String)Preconditions.checkNotNull((Object)builder.getFeedItemId());
        this.feedItemTargetType = (String)Preconditions.checkNotNull((Object)builder.getFeedItemTargetType());
        this.feedItemTargetId = (String)Preconditions.checkNotNull((Object)builder.getFeedItemTargetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getFeedItemId() {
        return this.feedItemId;
    }

    public String getFeedItemTargetType() {
        return this.feedItemTargetType;
    }

    public String getFeedItemTargetId() {
        return this.feedItemTargetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeedItemTargetName of(String customerId, String feedId, String feedItemId, String feedItemTargetType, String feedItemTargetId) {
        return FeedItemTargetName.newBuilder().setCustomerId(customerId).setFeedId(feedId).setFeedItemId(feedItemId).setFeedItemTargetType(feedItemTargetType).setFeedItemTargetId(feedItemTargetId).build();
    }

    public static String format(String customerId, String feedId, String feedItemId, String feedItemTargetType, String feedItemTargetId) {
        return FeedItemTargetName.newBuilder().setCustomerId(customerId).setFeedId(feedId).setFeedItemId(feedItemId).setFeedItemTargetType(feedItemTargetType).setFeedItemTargetId(feedItemTargetId).build().toString();
    }

    public static FeedItemTargetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_FEED_ID_FEED_ITEM_ID_FEED_ITEM_TARGET_TYPE_FEED_ITEM_TARGET_ID.validatedMatch(formattedString, "FeedItemTargetName.parse: formattedString not in valid format");
        return FeedItemTargetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("feed_id"), (String)matchMap.get("feed_item_id"), (String)matchMap.get("feed_item_target_type"), (String)matchMap.get("feed_item_target_id"));
    }

    public static List<FeedItemTargetName> parseList(List<String> formattedStrings) {
        ArrayList<FeedItemTargetName> list = new ArrayList<FeedItemTargetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedItemTargetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedItemTargetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedItemTargetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_FEED_ID_FEED_ITEM_ID_FEED_ITEM_TARGET_TYPE_FEED_ITEM_TARGET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedItemTargetName feedItemTargetName = this;
            synchronized (feedItemTargetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.feedId != null) {
                        fieldMapBuilder.put((Object)"feed_id", (Object)this.feedId);
                    }
                    if (this.feedItemId != null) {
                        fieldMapBuilder.put((Object)"feed_item_id", (Object)this.feedItemId);
                    }
                    if (this.feedItemTargetType != null) {
                        fieldMapBuilder.put((Object)"feed_item_target_type", (Object)this.feedItemTargetType);
                    }
                    if (this.feedItemTargetId != null) {
                        fieldMapBuilder.put((Object)"feed_item_target_id", (Object)this.feedItemTargetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_FEED_ID_FEED_ITEM_ID_FEED_ITEM_TARGET_TYPE_FEED_ITEM_TARGET_ID.instantiate(new String[]{"customer_id", this.customerId, "feed_id", this.feedId, "feed_item_id", this.feedItemId, "feed_item_target_type", this.feedItemTargetType, "feed_item_target_id", this.feedItemTargetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            FeedItemTargetName that = (FeedItemTargetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.feedId, that.feedId) && Objects.equals(this.feedItemId, that.feedItemId) && Objects.equals(this.feedItemTargetType, that.feedItemTargetType) && Objects.equals(this.feedItemTargetId, that.feedItemTargetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.feedId);
        h *= 1000003;
        h ^= Objects.hashCode(this.feedItemId);
        h *= 1000003;
        h ^= Objects.hashCode(this.feedItemTargetType);
        h *= 1000003;
        return h ^= Objects.hashCode(this.feedItemTargetId);
    }

    public static class Builder {
        private String customerId;
        private String feedId;
        private String feedItemId;
        private String feedItemTargetType;
        private String feedItemTargetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getFeedId() {
            return this.feedId;
        }

        public String getFeedItemId() {
            return this.feedItemId;
        }

        public String getFeedItemTargetType() {
            return this.feedItemTargetType;
        }

        public String getFeedItemTargetId() {
            return this.feedItemTargetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setFeedId(String feedId) {
            this.feedId = feedId;
            return this;
        }

        public Builder setFeedItemId(String feedItemId) {
            this.feedItemId = feedItemId;
            return this;
        }

        public Builder setFeedItemTargetType(String feedItemTargetType) {
            this.feedItemTargetType = feedItemTargetType;
            return this;
        }

        public Builder setFeedItemTargetId(String feedItemTargetId) {
            this.feedItemTargetId = feedItemTargetId;
            return this;
        }

        private Builder(FeedItemTargetName feedItemTargetName) {
            this.customerId = feedItemTargetName.customerId;
            this.feedId = feedItemTargetName.feedId;
            this.feedItemId = feedItemTargetName.feedItemId;
            this.feedItemTargetType = feedItemTargetName.feedItemTargetType;
            this.feedItemTargetId = feedItemTargetName.feedItemTargetId;
        }

        public FeedItemTargetName build() {
            return new FeedItemTargetName(this);
        }
    }
}

