/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.AccountBudget;
import com.google.ads.googleads.v7.resources.AccountBudgetName;
import com.google.ads.googleads.v7.services.AccountBudgetServiceSettings;
import com.google.ads.googleads.v7.services.GetAccountBudgetRequest;
import com.google.ads.googleads.v7.services.stub.AccountBudgetServiceStub;
import com.google.ads.googleads.v7.services.stub.AccountBudgetServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AccountBudgetServiceClient
implements BackgroundResource {
    private final AccountBudgetServiceSettings settings;
    private final AccountBudgetServiceStub stub;

    public static final AccountBudgetServiceClient create() throws IOException {
        return AccountBudgetServiceClient.create(AccountBudgetServiceSettings.newBuilder().build());
    }

    public static final AccountBudgetServiceClient create(AccountBudgetServiceSettings settings) throws IOException {
        return new AccountBudgetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AccountBudgetServiceClient create(AccountBudgetServiceStub stub) {
        return new AccountBudgetServiceClient(stub);
    }

    protected AccountBudgetServiceClient(AccountBudgetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AccountBudgetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AccountBudgetServiceClient(AccountBudgetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AccountBudgetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AccountBudgetServiceStub getStub() {
        return this.stub;
    }

    public final AccountBudget getAccountBudget(AccountBudgetName resourceName) {
        GetAccountBudgetRequest request = GetAccountBudgetRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAccountBudget(request);
    }

    public final AccountBudget getAccountBudget(String resourceName) {
        GetAccountBudgetRequest request = GetAccountBudgetRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAccountBudget(request);
    }

    public final AccountBudget getAccountBudget(GetAccountBudgetRequest request) {
        return (AccountBudget)this.getAccountBudgetCallable().call((Object)request);
    }

    public final UnaryCallable<GetAccountBudgetRequest, AccountBudget> getAccountBudgetCallable() {
        return this.stub.getAccountBudgetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

