/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.AdGroupAudienceView;
import com.google.ads.googleads.v7.resources.AdGroupAudienceViewName;
import com.google.ads.googleads.v7.services.AdGroupAudienceViewServiceSettings;
import com.google.ads.googleads.v7.services.GetAdGroupAudienceViewRequest;
import com.google.ads.googleads.v7.services.stub.AdGroupAudienceViewServiceStub;
import com.google.ads.googleads.v7.services.stub.AdGroupAudienceViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AdGroupAudienceViewServiceClient
implements BackgroundResource {
    private final AdGroupAudienceViewServiceSettings settings;
    private final AdGroupAudienceViewServiceStub stub;

    public static final AdGroupAudienceViewServiceClient create() throws IOException {
        return AdGroupAudienceViewServiceClient.create(AdGroupAudienceViewServiceSettings.newBuilder().build());
    }

    public static final AdGroupAudienceViewServiceClient create(AdGroupAudienceViewServiceSettings settings) throws IOException {
        return new AdGroupAudienceViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdGroupAudienceViewServiceClient create(AdGroupAudienceViewServiceStub stub) {
        return new AdGroupAudienceViewServiceClient(stub);
    }

    protected AdGroupAudienceViewServiceClient(AdGroupAudienceViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupAudienceViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdGroupAudienceViewServiceClient(AdGroupAudienceViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupAudienceViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdGroupAudienceViewServiceStub getStub() {
        return this.stub;
    }

    public final AdGroupAudienceView getAdGroupAudienceView(AdGroupAudienceViewName resourceName) {
        GetAdGroupAudienceViewRequest request = GetAdGroupAudienceViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAdGroupAudienceView(request);
    }

    public final AdGroupAudienceView getAdGroupAudienceView(String resourceName) {
        GetAdGroupAudienceViewRequest request = GetAdGroupAudienceViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAdGroupAudienceView(request);
    }

    public final AdGroupAudienceView getAdGroupAudienceView(GetAdGroupAudienceViewRequest request) {
        return (AdGroupAudienceView)this.getAdGroupAudienceViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdGroupAudienceViewRequest, AdGroupAudienceView> getAdGroupAudienceViewCallable() {
        return this.stub.getAdGroupAudienceViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

