/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.AdGroupCriterion;
import com.google.ads.googleads.v7.resources.AdGroupCriterionName;
import com.google.ads.googleads.v7.services.AdGroupCriterionOperation;
import com.google.ads.googleads.v7.services.AdGroupCriterionServiceSettings;
import com.google.ads.googleads.v7.services.GetAdGroupCriterionRequest;
import com.google.ads.googleads.v7.services.MutateAdGroupCriteriaRequest;
import com.google.ads.googleads.v7.services.MutateAdGroupCriteriaResponse;
import com.google.ads.googleads.v7.services.stub.AdGroupCriterionServiceStub;
import com.google.ads.googleads.v7.services.stub.AdGroupCriterionServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupCriterionServiceClient
implements BackgroundResource {
    private final AdGroupCriterionServiceSettings settings;
    private final AdGroupCriterionServiceStub stub;

    public static final AdGroupCriterionServiceClient create() throws IOException {
        return AdGroupCriterionServiceClient.create(AdGroupCriterionServiceSettings.newBuilder().build());
    }

    public static final AdGroupCriterionServiceClient create(AdGroupCriterionServiceSettings settings) throws IOException {
        return new AdGroupCriterionServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdGroupCriterionServiceClient create(AdGroupCriterionServiceStub stub) {
        return new AdGroupCriterionServiceClient(stub);
    }

    protected AdGroupCriterionServiceClient(AdGroupCriterionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupCriterionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdGroupCriterionServiceClient(AdGroupCriterionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupCriterionServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdGroupCriterionServiceStub getStub() {
        return this.stub;
    }

    public final AdGroupCriterion getAdGroupCriterion(AdGroupCriterionName resourceName) {
        GetAdGroupCriterionRequest request = GetAdGroupCriterionRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAdGroupCriterion(request);
    }

    public final AdGroupCriterion getAdGroupCriterion(String resourceName) {
        GetAdGroupCriterionRequest request = GetAdGroupCriterionRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAdGroupCriterion(request);
    }

    public final AdGroupCriterion getAdGroupCriterion(GetAdGroupCriterionRequest request) {
        return (AdGroupCriterion)this.getAdGroupCriterionCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdGroupCriterionRequest, AdGroupCriterion> getAdGroupCriterionCallable() {
        return this.stub.getAdGroupCriterionCallable();
    }

    public final MutateAdGroupCriteriaResponse mutateAdGroupCriteria(String customerId, List<AdGroupCriterionOperation> operations) {
        MutateAdGroupCriteriaRequest request = MutateAdGroupCriteriaRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupCriteria(request);
    }

    public final MutateAdGroupCriteriaResponse mutateAdGroupCriteria(MutateAdGroupCriteriaRequest request) {
        return (MutateAdGroupCriteriaResponse)this.mutateAdGroupCriteriaCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupCriteriaRequest, MutateAdGroupCriteriaResponse> mutateAdGroupCriteriaCallable() {
        return this.stub.mutateAdGroupCriteriaCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

