/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.Campaign;
import com.google.ads.googleads.v7.resources.CampaignName;
import com.google.ads.googleads.v7.services.CampaignOperation;
import com.google.ads.googleads.v7.services.CampaignServiceSettings;
import com.google.ads.googleads.v7.services.GetCampaignRequest;
import com.google.ads.googleads.v7.services.MutateCampaignsRequest;
import com.google.ads.googleads.v7.services.MutateCampaignsResponse;
import com.google.ads.googleads.v7.services.stub.CampaignServiceStub;
import com.google.ads.googleads.v7.services.stub.CampaignServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CampaignServiceClient
implements BackgroundResource {
    private final CampaignServiceSettings settings;
    private final CampaignServiceStub stub;

    public static final CampaignServiceClient create() throws IOException {
        return CampaignServiceClient.create(CampaignServiceSettings.newBuilder().build());
    }

    public static final CampaignServiceClient create(CampaignServiceSettings settings) throws IOException {
        return new CampaignServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CampaignServiceClient create(CampaignServiceStub stub) {
        return new CampaignServiceClient(stub);
    }

    protected CampaignServiceClient(CampaignServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CampaignServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CampaignServiceClient(CampaignServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CampaignServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CampaignServiceStub getStub() {
        return this.stub;
    }

    public final Campaign getCampaign(CampaignName resourceName) {
        GetCampaignRequest request = GetCampaignRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCampaign(request);
    }

    public final Campaign getCampaign(String resourceName) {
        GetCampaignRequest request = GetCampaignRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCampaign(request);
    }

    public final Campaign getCampaign(GetCampaignRequest request) {
        return (Campaign)this.getCampaignCallable().call((Object)request);
    }

    public final UnaryCallable<GetCampaignRequest, Campaign> getCampaignCallable() {
        return this.stub.getCampaignCallable();
    }

    public final MutateCampaignsResponse mutateCampaigns(String customerId, List<CampaignOperation> operations) {
        MutateCampaignsRequest request = MutateCampaignsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCampaigns(request);
    }

    public final MutateCampaignsResponse mutateCampaigns(MutateCampaignsRequest request) {
        return (MutateCampaignsResponse)this.mutateCampaignsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCampaignsRequest, MutateCampaignsResponse> mutateCampaignsCallable() {
        return this.stub.mutateCampaignsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

