/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.CustomAudience;
import com.google.ads.googleads.v7.resources.CustomAudienceName;
import com.google.ads.googleads.v7.services.CustomAudienceOperation;
import com.google.ads.googleads.v7.services.CustomAudienceServiceSettings;
import com.google.ads.googleads.v7.services.GetCustomAudienceRequest;
import com.google.ads.googleads.v7.services.MutateCustomAudiencesRequest;
import com.google.ads.googleads.v7.services.MutateCustomAudiencesResponse;
import com.google.ads.googleads.v7.services.stub.CustomAudienceServiceStub;
import com.google.ads.googleads.v7.services.stub.CustomAudienceServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomAudienceServiceClient
implements BackgroundResource {
    private final CustomAudienceServiceSettings settings;
    private final CustomAudienceServiceStub stub;

    public static final CustomAudienceServiceClient create() throws IOException {
        return CustomAudienceServiceClient.create(CustomAudienceServiceSettings.newBuilder().build());
    }

    public static final CustomAudienceServiceClient create(CustomAudienceServiceSettings settings) throws IOException {
        return new CustomAudienceServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CustomAudienceServiceClient create(CustomAudienceServiceStub stub) {
        return new CustomAudienceServiceClient(stub);
    }

    protected CustomAudienceServiceClient(CustomAudienceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomAudienceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CustomAudienceServiceClient(CustomAudienceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomAudienceServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomAudienceServiceStub getStub() {
        return this.stub;
    }

    public final CustomAudience getCustomAudience(CustomAudienceName resourceName) {
        GetCustomAudienceRequest request = GetCustomAudienceRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCustomAudience(request);
    }

    public final CustomAudience getCustomAudience(String resourceName) {
        GetCustomAudienceRequest request = GetCustomAudienceRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCustomAudience(request);
    }

    public final CustomAudience getCustomAudience(GetCustomAudienceRequest request) {
        return (CustomAudience)this.getCustomAudienceCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomAudienceRequest, CustomAudience> getCustomAudienceCallable() {
        return this.stub.getCustomAudienceCallable();
    }

    public final MutateCustomAudiencesResponse mutateCustomAudiences(String customerId, List<CustomAudienceOperation> operations) {
        MutateCustomAudiencesRequest request = MutateCustomAudiencesRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomAudiences(request);
    }

    public final MutateCustomAudiencesResponse mutateCustomAudiences(MutateCustomAudiencesRequest request) {
        return (MutateCustomAudiencesResponse)this.mutateCustomAudiencesCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomAudiencesRequest, MutateCustomAudiencesResponse> mutateCustomAudiencesCallable() {
        return this.stub.mutateCustomAudiencesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

