/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.FeedItem;
import com.google.ads.googleads.v7.resources.FeedItemName;
import com.google.ads.googleads.v7.services.FeedItemOperation;
import com.google.ads.googleads.v7.services.FeedItemServiceSettings;
import com.google.ads.googleads.v7.services.GetFeedItemRequest;
import com.google.ads.googleads.v7.services.MutateFeedItemsRequest;
import com.google.ads.googleads.v7.services.MutateFeedItemsResponse;
import com.google.ads.googleads.v7.services.stub.FeedItemServiceStub;
import com.google.ads.googleads.v7.services.stub.FeedItemServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FeedItemServiceClient
implements BackgroundResource {
    private final FeedItemServiceSettings settings;
    private final FeedItemServiceStub stub;

    public static final FeedItemServiceClient create() throws IOException {
        return FeedItemServiceClient.create(FeedItemServiceSettings.newBuilder().build());
    }

    public static final FeedItemServiceClient create(FeedItemServiceSettings settings) throws IOException {
        return new FeedItemServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FeedItemServiceClient create(FeedItemServiceStub stub) {
        return new FeedItemServiceClient(stub);
    }

    protected FeedItemServiceClient(FeedItemServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeedItemServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FeedItemServiceClient(FeedItemServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FeedItemServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FeedItemServiceStub getStub() {
        return this.stub;
    }

    public final FeedItem getFeedItem(FeedItemName resourceName) {
        GetFeedItemRequest request = GetFeedItemRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getFeedItem(request);
    }

    public final FeedItem getFeedItem(String resourceName) {
        GetFeedItemRequest request = GetFeedItemRequest.newBuilder().setResourceName(resourceName).build();
        return this.getFeedItem(request);
    }

    public final FeedItem getFeedItem(GetFeedItemRequest request) {
        return (FeedItem)this.getFeedItemCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeedItemRequest, FeedItem> getFeedItemCallable() {
        return this.stub.getFeedItemCallable();
    }

    public final MutateFeedItemsResponse mutateFeedItems(String customerId, List<FeedItemOperation> operations) {
        MutateFeedItemsRequest request = MutateFeedItemsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateFeedItems(request);
    }

    public final MutateFeedItemsResponse mutateFeedItems(MutateFeedItemsRequest request) {
        return (MutateFeedItemsResponse)this.mutateFeedItemsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateFeedItemsRequest, MutateFeedItemsResponse> mutateFeedItemsCallable() {
        return this.stub.mutateFeedItemsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

