/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.LifeEvent;
import com.google.ads.googleads.v7.resources.LifeEventName;
import com.google.ads.googleads.v7.services.GetLifeEventRequest;
import com.google.ads.googleads.v7.services.LifeEventServiceSettings;
import com.google.ads.googleads.v7.services.stub.LifeEventServiceStub;
import com.google.ads.googleads.v7.services.stub.LifeEventServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class LifeEventServiceClient
implements BackgroundResource {
    private final LifeEventServiceSettings settings;
    private final LifeEventServiceStub stub;

    public static final LifeEventServiceClient create() throws IOException {
        return LifeEventServiceClient.create(LifeEventServiceSettings.newBuilder().build());
    }

    public static final LifeEventServiceClient create(LifeEventServiceSettings settings) throws IOException {
        return new LifeEventServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LifeEventServiceClient create(LifeEventServiceStub stub) {
        return new LifeEventServiceClient(stub);
    }

    protected LifeEventServiceClient(LifeEventServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LifeEventServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LifeEventServiceClient(LifeEventServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LifeEventServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LifeEventServiceStub getStub() {
        return this.stub;
    }

    public final LifeEvent getLifeEvent(LifeEventName resourceName) {
        GetLifeEventRequest request = GetLifeEventRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getLifeEvent(request);
    }

    public final LifeEvent getLifeEvent(String resourceName) {
        GetLifeEventRequest request = GetLifeEventRequest.newBuilder().setResourceName(resourceName).build();
        return this.getLifeEvent(request);
    }

    public final LifeEvent getLifeEvent(GetLifeEventRequest request) {
        return (LifeEvent)this.getLifeEventCallable().call((Object)request);
    }

    public final UnaryCallable<GetLifeEventRequest, LifeEvent> getLifeEventCallable() {
        return this.stub.getLifeEventCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

