/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.LocationView;
import com.google.ads.googleads.v7.resources.LocationViewName;
import com.google.ads.googleads.v7.services.GetLocationViewRequest;
import com.google.ads.googleads.v7.services.LocationViewServiceSettings;
import com.google.ads.googleads.v7.services.stub.LocationViewServiceStub;
import com.google.ads.googleads.v7.services.stub.LocationViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class LocationViewServiceClient
implements BackgroundResource {
    private final LocationViewServiceSettings settings;
    private final LocationViewServiceStub stub;

    public static final LocationViewServiceClient create() throws IOException {
        return LocationViewServiceClient.create(LocationViewServiceSettings.newBuilder().build());
    }

    public static final LocationViewServiceClient create(LocationViewServiceSettings settings) throws IOException {
        return new LocationViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LocationViewServiceClient create(LocationViewServiceStub stub) {
        return new LocationViewServiceClient(stub);
    }

    protected LocationViewServiceClient(LocationViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LocationViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LocationViewServiceClient(LocationViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LocationViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LocationViewServiceStub getStub() {
        return this.stub;
    }

    public final LocationView getLocationView(LocationViewName resourceName) {
        GetLocationViewRequest request = GetLocationViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getLocationView(request);
    }

    public final LocationView getLocationView(String resourceName) {
        GetLocationViewRequest request = GetLocationViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getLocationView(request);
    }

    public final LocationView getLocationView(GetLocationViewRequest request) {
        return (LocationView)this.getLocationViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationViewRequest, LocationView> getLocationViewCallable() {
        return this.stub.getLocationViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

