/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services;

import com.google.ads.googleads.v7.resources.WebpageView;
import com.google.ads.googleads.v7.resources.WebpageViewName;
import com.google.ads.googleads.v7.services.GetWebpageViewRequest;
import com.google.ads.googleads.v7.services.WebpageViewServiceSettings;
import com.google.ads.googleads.v7.services.stub.WebpageViewServiceStub;
import com.google.ads.googleads.v7.services.stub.WebpageViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class WebpageViewServiceClient
implements BackgroundResource {
    private final WebpageViewServiceSettings settings;
    private final WebpageViewServiceStub stub;

    public static final WebpageViewServiceClient create() throws IOException {
        return WebpageViewServiceClient.create(WebpageViewServiceSettings.newBuilder().build());
    }

    public static final WebpageViewServiceClient create(WebpageViewServiceSettings settings) throws IOException {
        return new WebpageViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final WebpageViewServiceClient create(WebpageViewServiceStub stub) {
        return new WebpageViewServiceClient(stub);
    }

    protected WebpageViewServiceClient(WebpageViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WebpageViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected WebpageViewServiceClient(WebpageViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final WebpageViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public WebpageViewServiceStub getStub() {
        return this.stub;
    }

    public final WebpageView getWebpageView(WebpageViewName resourceName) {
        GetWebpageViewRequest request = GetWebpageViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getWebpageView(request);
    }

    public final WebpageView getWebpageView(String resourceName) {
        GetWebpageViewRequest request = GetWebpageViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getWebpageView(request);
    }

    public final WebpageView getWebpageView(GetWebpageViewRequest request) {
        return (WebpageView)this.getWebpageViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetWebpageViewRequest, WebpageView> getWebpageViewCallable() {
        return this.stub.getWebpageViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

