/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.CustomerNegativeCriterion;
import com.google.ads.googleads.v7.services.GetCustomerNegativeCriterionRequest;
import com.google.ads.googleads.v7.services.MutateCustomerNegativeCriteriaRequest;
import com.google.ads.googleads.v7.services.MutateCustomerNegativeCriteriaResponse;
import com.google.ads.googleads.v7.services.stub.CustomerNegativeCriterionServiceStub;
import com.google.ads.googleads.v7.services.stub.GrpcCustomerNegativeCriterionServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CustomerNegativeCriterionServiceStubSettings
extends StubSettings<CustomerNegativeCriterionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<GetCustomerNegativeCriterionRequest, CustomerNegativeCriterion> getCustomerNegativeCriterionSettings;
    private final UnaryCallSettings<MutateCustomerNegativeCriteriaRequest, MutateCustomerNegativeCriteriaResponse> mutateCustomerNegativeCriteriaSettings;

    public UnaryCallSettings<GetCustomerNegativeCriterionRequest, CustomerNegativeCriterion> getCustomerNegativeCriterionSettings() {
        return this.getCustomerNegativeCriterionSettings;
    }

    public UnaryCallSettings<MutateCustomerNegativeCriteriaRequest, MutateCustomerNegativeCriteriaResponse> mutateCustomerNegativeCriteriaSettings() {
        return this.mutateCustomerNegativeCriteriaSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomerNegativeCriterionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCustomerNegativeCriterionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CustomerNegativeCriterionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CustomerNegativeCriterionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CustomerNegativeCriterionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCustomerNegativeCriterionSettings = settingsBuilder.getCustomerNegativeCriterionSettings().build();
        this.mutateCustomerNegativeCriteriaSettings = settingsBuilder.mutateCustomerNegativeCriteriaSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CustomerNegativeCriterionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCustomerNegativeCriterionRequest, CustomerNegativeCriterion> getCustomerNegativeCriterionSettings;
        private final UnaryCallSettings.Builder<MutateCustomerNegativeCriteriaRequest, MutateCustomerNegativeCriteriaResponse> mutateCustomerNegativeCriteriaSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCustomerNegativeCriterionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.mutateCustomerNegativeCriteriaSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCustomerNegativeCriterionSettings, this.mutateCustomerNegativeCriteriaSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CustomerNegativeCriterionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCustomerNegativeCriterionSettings = settings.getCustomerNegativeCriterionSettings.toBuilder();
            this.mutateCustomerNegativeCriteriaSettings = settings.mutateCustomerNegativeCriteriaSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCustomerNegativeCriterionSettings, this.mutateCustomerNegativeCriteriaSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CustomerNegativeCriterionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CustomerNegativeCriterionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CustomerNegativeCriterionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CustomerNegativeCriterionServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCustomerNegativeCriterionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.mutateCustomerNegativeCriteriaSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCustomerNegativeCriterionRequest, CustomerNegativeCriterion> getCustomerNegativeCriterionSettings() {
            return this.getCustomerNegativeCriterionSettings;
        }

        public UnaryCallSettings.Builder<MutateCustomerNegativeCriteriaRequest, MutateCustomerNegativeCriteriaResponse> mutateCustomerNegativeCriteriaSettings() {
            return this.mutateCustomerNegativeCriteriaSettings;
        }

        public CustomerNegativeCriterionServiceStubSettings build() throws IOException {
            return new CustomerNegativeCriterionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

