/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.AdScheduleView;
import com.google.ads.googleads.v7.services.GetAdScheduleViewRequest;
import com.google.ads.googleads.v7.services.stub.AdScheduleViewServiceStub;
import com.google.ads.googleads.v7.services.stub.AdScheduleViewServiceStubSettings;
import com.google.ads.googleads.v7.services.stub.GrpcAdScheduleViewServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcAdScheduleViewServiceStub
extends AdScheduleViewServiceStub {
    private static final MethodDescriptor<GetAdScheduleViewRequest, AdScheduleView> getAdScheduleViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.AdScheduleViewService/GetAdScheduleView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAdScheduleViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdScheduleView.getDefaultInstance())).build();
    private final UnaryCallable<GetAdScheduleViewRequest, AdScheduleView> getAdScheduleViewCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdScheduleViewServiceStub create(AdScheduleViewServiceStubSettings settings) throws IOException {
        return new GrpcAdScheduleViewServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdScheduleViewServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdScheduleViewServiceStub(AdScheduleViewServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdScheduleViewServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdScheduleViewServiceStub(AdScheduleViewServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdScheduleViewServiceStub(AdScheduleViewServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdScheduleViewServiceCallableFactory());
    }

    protected GrpcAdScheduleViewServiceStub(AdScheduleViewServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getAdScheduleViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAdScheduleViewMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetAdScheduleViewRequest>(){

            public Map<String, String> extract(GetAdScheduleViewRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getAdScheduleViewCallable = callableFactory.createUnaryCallable(getAdScheduleViewTransportSettings, settings.getAdScheduleViewSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetAdScheduleViewRequest, AdScheduleView> getAdScheduleViewCallable() {
        return this.getAdScheduleViewCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

