/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.BillingSetup;
import com.google.ads.googleads.v7.services.GetBillingSetupRequest;
import com.google.ads.googleads.v7.services.MutateBillingSetupRequest;
import com.google.ads.googleads.v7.services.MutateBillingSetupResponse;
import com.google.ads.googleads.v7.services.stub.BillingSetupServiceStub;
import com.google.ads.googleads.v7.services.stub.BillingSetupServiceStubSettings;
import com.google.ads.googleads.v7.services.stub.GrpcBillingSetupServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcBillingSetupServiceStub
extends BillingSetupServiceStub {
    private static final MethodDescriptor<GetBillingSetupRequest, BillingSetup> getBillingSetupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.BillingSetupService/GetBillingSetup").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBillingSetupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BillingSetup.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateBillingSetupRequest, MutateBillingSetupResponse> mutateBillingSetupMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.BillingSetupService/MutateBillingSetup").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateBillingSetupRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateBillingSetupResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetBillingSetupRequest, BillingSetup> getBillingSetupCallable;
    private final UnaryCallable<MutateBillingSetupRequest, MutateBillingSetupResponse> mutateBillingSetupCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBillingSetupServiceStub create(BillingSetupServiceStubSettings settings) throws IOException {
        return new GrpcBillingSetupServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBillingSetupServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcBillingSetupServiceStub(BillingSetupServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBillingSetupServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBillingSetupServiceStub(BillingSetupServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBillingSetupServiceStub(BillingSetupServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBillingSetupServiceCallableFactory());
    }

    protected GrpcBillingSetupServiceStub(BillingSetupServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getBillingSetupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBillingSetupMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetBillingSetupRequest>(){

            public Map<String, String> extract(GetBillingSetupRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateBillingSetupTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateBillingSetupMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateBillingSetupRequest>(){

            public Map<String, String> extract(MutateBillingSetupRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getBillingSetupCallable = callableFactory.createUnaryCallable(getBillingSetupTransportSettings, settings.getBillingSetupSettings(), clientContext);
        this.mutateBillingSetupCallable = callableFactory.createUnaryCallable(mutateBillingSetupTransportSettings, settings.mutateBillingSetupSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetBillingSetupRequest, BillingSetup> getBillingSetupCallable() {
        return this.getBillingSetupCallable;
    }

    @Override
    public UnaryCallable<MutateBillingSetupRequest, MutateBillingSetupResponse> mutateBillingSetupCallable() {
        return this.mutateBillingSetupCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

