/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.CampaignFeed;
import com.google.ads.googleads.v7.services.GetCampaignFeedRequest;
import com.google.ads.googleads.v7.services.MutateCampaignFeedsRequest;
import com.google.ads.googleads.v7.services.MutateCampaignFeedsResponse;
import com.google.ads.googleads.v7.services.stub.CampaignFeedServiceStub;
import com.google.ads.googleads.v7.services.stub.CampaignFeedServiceStubSettings;
import com.google.ads.googleads.v7.services.stub.GrpcCampaignFeedServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcCampaignFeedServiceStub
extends CampaignFeedServiceStub {
    private static final MethodDescriptor<GetCampaignFeedRequest, CampaignFeed> getCampaignFeedMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.CampaignFeedService/GetCampaignFeed").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCampaignFeedRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CampaignFeed.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateCampaignFeedsRequest, MutateCampaignFeedsResponse> mutateCampaignFeedsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.CampaignFeedService/MutateCampaignFeeds").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateCampaignFeedsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateCampaignFeedsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetCampaignFeedRequest, CampaignFeed> getCampaignFeedCallable;
    private final UnaryCallable<MutateCampaignFeedsRequest, MutateCampaignFeedsResponse> mutateCampaignFeedsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCampaignFeedServiceStub create(CampaignFeedServiceStubSettings settings) throws IOException {
        return new GrpcCampaignFeedServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCampaignFeedServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCampaignFeedServiceStub(CampaignFeedServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCampaignFeedServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCampaignFeedServiceStub(CampaignFeedServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCampaignFeedServiceStub(CampaignFeedServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCampaignFeedServiceCallableFactory());
    }

    protected GrpcCampaignFeedServiceStub(CampaignFeedServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getCampaignFeedTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCampaignFeedMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetCampaignFeedRequest>(){

            public Map<String, String> extract(GetCampaignFeedRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings mutateCampaignFeedsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateCampaignFeedsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MutateCampaignFeedsRequest>(){

            public Map<String, String> extract(MutateCampaignFeedsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
                return params.build();
            }
        }).build();
        this.getCampaignFeedCallable = callableFactory.createUnaryCallable(getCampaignFeedTransportSettings, settings.getCampaignFeedSettings(), clientContext);
        this.mutateCampaignFeedsCallable = callableFactory.createUnaryCallable(mutateCampaignFeedsTransportSettings, settings.mutateCampaignFeedsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetCampaignFeedRequest, CampaignFeed> getCampaignFeedCallable() {
        return this.getCampaignFeedCallable;
    }

    @Override
    public UnaryCallable<MutateCampaignFeedsRequest, MutateCampaignFeedsResponse> mutateCampaignFeedsCallable() {
        return this.mutateCampaignFeedsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

