/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v7.services.stub;

import com.google.ads.googleads.v7.resources.DistanceView;
import com.google.ads.googleads.v7.services.GetDistanceViewRequest;
import com.google.ads.googleads.v7.services.stub.DistanceViewServiceStub;
import com.google.ads.googleads.v7.services.stub.DistanceViewServiceStubSettings;
import com.google.ads.googleads.v7.services.stub.GrpcDistanceViewServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcDistanceViewServiceStub
extends DistanceViewServiceStub {
    private static final MethodDescriptor<GetDistanceViewRequest, DistanceView> getDistanceViewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v7.services.DistanceViewService/GetDistanceView").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDistanceViewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DistanceView.getDefaultInstance())).build();
    private final UnaryCallable<GetDistanceViewRequest, DistanceView> getDistanceViewCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDistanceViewServiceStub create(DistanceViewServiceStubSettings settings) throws IOException {
        return new GrpcDistanceViewServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDistanceViewServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDistanceViewServiceStub(DistanceViewServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDistanceViewServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDistanceViewServiceStub(DistanceViewServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDistanceViewServiceStub(DistanceViewServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDistanceViewServiceCallableFactory());
    }

    protected GrpcDistanceViewServiceStub(DistanceViewServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getDistanceViewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDistanceViewMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetDistanceViewRequest>(){

            public Map<String, String> extract(GetDistanceViewRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource_name", (Object)String.valueOf(request.getResourceName()));
                return params.build();
            }
        }).build();
        this.getDistanceViewCallable = callableFactory.createUnaryCallable(getDistanceViewTransportSettings, settings.getDistanceViewSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetDistanceViewRequest, DistanceView> getDistanceViewCallable() {
        return this.getDistanceViewCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

